/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.algorithmrunconfiguration;

import ca.ubc.cs.beta.aeatk.algorithmexecutionconfiguration.AlgorithmExecutionConfiguration;
import ca.ubc.cs.beta.aeatk.json.serializers.AlgorithmRunConfigurationJson;
import ca.ubc.cs.beta.aeatk.parameterconfigurationspace.ParameterConfiguration;
import ca.ubc.cs.beta.aeatk.probleminstance.ProblemInstanceSeedPair;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;

@JsonSerialize(using=AlgorithmRunConfigurationJson.RunConfigSerializer.class)
@JsonDeserialize(using=AlgorithmRunConfigurationJson.RunConfigDeserializer.class)
public class AlgorithmRunConfiguration
implements Serializable {
    private static final long serialVersionUID = 7749039021874017859L;
    private final ProblemInstanceSeedPair pisp;
    private final double cutoffTime;
    private final ParameterConfiguration params;
    private final boolean cutoffLessThanMax;
    private final AlgorithmExecutionConfiguration algorithmExecutionConfiguration;

    public AlgorithmRunConfiguration(ProblemInstanceSeedPair pisp, double cutoffTime, ParameterConfiguration config, AlgorithmExecutionConfiguration execConfig) {
        if (pisp == null) {
            throw new IllegalArgumentException("ProblemInstanceSeedPair cannot be null");
        }
        if (config == null) {
            throw new IllegalArgumentException("ParamConfiguration cannot be null");
        }
        if (cutoffTime < 0.0) {
            throw new IllegalArgumentException("Cutoff time must be non-negative positive");
        }
        if (execConfig == null) {
            throw new IllegalArgumentException("Algorithm Execution Configuration cannot be null");
        }
        if (!config.getParameterConfigurationSpace().equals(execConfig.getParameterConfigurationSpace())) {
            throw new IllegalArgumentException("Configuration Space of ParamConfiguration, and that of the AlgorithmExecutionConfig object need to be the same.");
        }
        this.pisp = pisp;
        this.cutoffTime = cutoffTime;
        if (config.isLocked()) {
            this.params = config;
        } else {
            this.params = config.copy();
            this.params.lock();
        }
        this.cutoffLessThanMax = cutoffTime < execConfig.getAlgorithmMaximumCutoffTime();
        this.algorithmExecutionConfiguration = execConfig;
    }

    public AlgorithmRunConfiguration(ProblemInstanceSeedPair pisp, ParameterConfiguration config, AlgorithmExecutionConfiguration execConfig) {
        this(pisp, execConfig.getAlgorithmMaximumCutoffTime(), config, execConfig);
    }

    public ProblemInstanceSeedPair getProblemInstanceSeedPair() {
        return this.pisp;
    }

    public double getCutoffTime() {
        return this.cutoffTime;
    }

    public ParameterConfiguration getParameterConfiguration() {
        return this.params;
    }

    public boolean hasCutoffLessThanMax() {
        return this.cutoffLessThanMax;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof AlgorithmRunConfiguration) {
            AlgorithmRunConfiguration oar = (AlgorithmRunConfiguration)o;
            return this.pisp.equals(oar.pisp) && this.cutoffTime == oar.cutoffTime && this.params.equals(oar.params) && this.algorithmExecutionConfiguration.equals(oar.algorithmExecutionConfiguration);
        }
        return false;
    }

    public int hashCode() {
        return this.pisp.hashCode() ^ this.params.hashCode() + 37 * this.algorithmExecutionConfiguration.hashCode();
    }

    public String toString() {
        int instID = this.getProblemInstanceSeedPair().getProblemInstance().getInstanceID();
        long seed = this.getProblemInstanceSeedPair().getSeed();
        String confID = this.params.getFriendlyIDHex();
        StringBuilder sb = new StringBuilder();
        sb.append("<Instance:" + instID + ", Seed:" + seed + ", Config:" + confID + ", Kappa:" + this.cutoffTime + ", Execution Config: " + this.getAlgorithmExecutionConfiguration().getFriendlyIDHex() + ">");
        return sb.toString();
    }

    public String getFriendlyRunInfo() {
        int instID = this.getProblemInstanceSeedPair().getProblemInstance().getInstanceID();
        long seed = this.getProblemInstanceSeedPair().getSeed();
        String confID = this.params.getFriendlyIDHex();
        return "Run for Instance (" + instID + ") Config (" + confID + ") Seed: (" + seed + ")";
    }

    public AlgorithmExecutionConfiguration getAlgorithmExecutionConfiguration() {
        return this.algorithmExecutionConfiguration;
    }
}

