/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.algorithmexecutionconfiguration;

import ca.ubc.cs.beta.aeatk.json.serializers.AlgorithmExecutionConfigurationJson;
import ca.ubc.cs.beta.aeatk.parameterconfigurationspace.ParameterConfigurationSpace;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonSerialize(using=AlgorithmExecutionConfigurationJson.AlgorithmExecutionConfigSerializer.class)
@JsonDeserialize(using=AlgorithmExecutionConfigurationJson.AlgorithmExecutionConfigDeserializer.class)
public class AlgorithmExecutionConfiguration
implements Serializable {
    private static final long serialVersionUID = 3L;
    private final String algorithmExecutable;
    private final String algorithmExecutionDirectory;
    private final ParameterConfigurationSpace paramFile;
    private final boolean deterministicAlgorithm;
    private final double cutoffTime;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Map<String, String> taeContext;
    private static final AtomicInteger idPool = new AtomicInteger(0);
    private int myID = idPool.incrementAndGet();

    public AlgorithmExecutionConfiguration(String algorithmExecutable, String algorithmExecutionDirectory, ParameterConfigurationSpace paramFile, boolean executeOnCluster, boolean deterministicAlgorithm, double cutoffTime) {
        this(algorithmExecutable, algorithmExecutionDirectory, paramFile, deterministicAlgorithm, cutoffTime, Collections.EMPTY_MAP);
    }

    public AlgorithmExecutionConfiguration(String algorithmExecutable, String algorithmExecutionDirectory, ParameterConfigurationSpace paramFile, boolean deterministicAlgorithm, double cutoffTime, Map<String, String> taeContext) {
        this.algorithmExecutable = algorithmExecutable;
        this.algorithmExecutionDirectory = algorithmExecutionDirectory;
        this.paramFile = paramFile;
        this.deterministicAlgorithm = deterministicAlgorithm;
        if (cutoffTime < 0.0) {
            throw new IllegalArgumentException("Cutoff time must be greater than zero");
        }
        if (cutoffTime == 0.0) {
            this.log.warn("Cutoff time should be greater than zero");
        }
        this.cutoffTime = cutoffTime;
        this.taeContext = new TreeMap<String, String>(taeContext);
    }

    public String getAlgorithmExecutable() {
        return this.algorithmExecutable;
    }

    public String getAlgorithmExecutionDirectory() {
        return this.algorithmExecutionDirectory;
    }

    public ParameterConfigurationSpace getParameterConfigurationSpace() {
        return this.paramFile;
    }

    public boolean isDeterministicAlgorithm() {
        return this.deterministicAlgorithm;
    }

    public Map<String, String> getTargetAlgorithmExecutionContext() {
        return Collections.unmodifiableMap(this.taeContext);
    }

    public int hashCode() {
        return this.algorithmExecutable.hashCode() ^ this.algorithmExecutionDirectory.hashCode() ^ this.paramFile.hashCode() ^ (this.deterministicAlgorithm ? 0 : 1) ^ this.taeContext.hashCode();
    }

    public String toString() {
        return "algoExec:" + this.algorithmExecutable + "\nAlgorithmExecutionDirectory:" + this.algorithmExecutionDirectory + "\n" + this.paramFile + "\nDetermininstic:" + this.deterministicAlgorithm + "\nID:" + this.myID + " MapSize:" + this.taeContext.size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof AlgorithmExecutionConfiguration) {
            AlgorithmExecutionConfiguration co = (AlgorithmExecutionConfiguration)o;
            return co.algorithmExecutable.equals(this.algorithmExecutable) && co.algorithmExecutionDirectory.equals(this.algorithmExecutionDirectory) && co.paramFile.equals(this.paramFile) && co.deterministicAlgorithm == this.deterministicAlgorithm && co.taeContext.equals(this.taeContext);
        }
        return false;
    }

    public double getAlgorithmMaximumCutoffTime() {
        return this.cutoffTime;
    }

    public int getFriendlyID() {
        return this.myID;
    }

    public String getFriendlyIDHex() {
        String hex = Integer.toHexString(this.getFriendlyID());
        StringBuilder sb = new StringBuilder("0x");
        while (hex.length() + sb.length() < 6) {
            sb.append("0");
        }
        sb.append(hex.toUpperCase());
        return sb.toString();
    }
}

