/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.acquisitionfunctions;

import ca.ubc.cs.beta.aeatk.acquisitionfunctions.AcquisitionFunction;
import ca.ubc.cs.beta.aeatk.acquisitionfunctions.AcquisitionFunctionHelper;
import ca.ubc.cs.beta.aeatk.misc.math.ArrayMathOps;

public class ExpectedImprovement
implements AcquisitionFunction {
    private static final double MIN_VALUE = -Math.pow(10.0, 100.0);
    private final double NEG103 = -Math.pow(10.0, -3.0);
    private final double POS103 = Math.pow(10.0, -3.0);

    @Override
    public double[] computeAcquisitionFunctionValue(double f_min_samples, double[] predmean, double[] predvar, double standardErrors) {
        double[] predstddev = ArrayMathOps.sqrt(predvar);
        double[] u = ArrayMathOps.divide(ArrayMathOps.subtract(f_min_samples, predmean), predstddev);
        double[] cdfU = AcquisitionFunctionHelper.normcdf(u);
        double[] pdfU = AcquisitionFunctionHelper.normpdf(u);
        double[] term1 = ArrayMathOps.times(ArrayMathOps.subtract(f_min_samples, predmean), cdfU);
        double[] term2 = ArrayMathOps.times(predstddev, pdfU);
        double[] standardEI = ArrayMathOps.add(term1, term2);
        double[] logEI = new double[standardEI.length];
        for (int i = 0; i < predmean.length; ++i) {
            double result;
            double mu = predmean[i];
            double sigma = predstddev[i];
            double x = (f_min_samples - mu) / sigma;
            if (Math.abs(f_min_samples - mu) == 0.0) {
                result = sigma > 0.0 ? Math.log(sigma) + AcquisitionFunctionHelper.normpdfln(x) : Double.NEGATIVE_INFINITY;
            } else if (sigma == 0.0) {
                result = mu < f_min_samples ? Math.log(f_min_samples - mu) : Double.NEGATIVE_INFINITY;
            } else {
                double a;
                double b = Math.log(sigma) + AcquisitionFunctionHelper.normpdfln(x);
                if (mu < f_min_samples) {
                    a = Math.log(f_min_samples - mu) + AcquisitionFunctionHelper.normcdfln(x);
                    result = Math.max(a, b) + Math.log1p(Math.exp(-Math.abs(b - a)));
                    this.checkAssertions(result, standardEI[i], predmean[i], predvar[i]);
                } else {
                    a = ArrayMathOps.log(mu - f_min_samples) + AcquisitionFunctionHelper.normcdfln(x);
                    if (a >= b) {
                        result = Double.NEGATIVE_INFINITY;
                    } else {
                        result = b + Math.log1p(-ArrayMathOps.exp(a - b));
                        this.checkAssertions(result, standardEI[i], predmean[i], predvar[i]);
                    }
                }
            }
            logEI[i] = -Math.max(MIN_VALUE, result);
        }
        return logEI;
    }

    private void checkAssertions(double logEI, double EI, double predmean, double predvar) {
        double delta = Math.exp(logEI) - EI;
        if (Double.isNaN(logEI)) {
            throw new IllegalStateException("Log Expected Improvement has a NaN value. This probably indicates a bug, and you should contact the developer if you get this error (hopefully you can reproduce it). Expected improvement was: " + EI + "predmean:" + predmean + " predvar" + predvar);
        }
        if (delta < this.NEG103) {
            throw new IllegalStateException("Log-EI and EI have a difference " + delta + " expected it to be greater than -10^-3. Please contact the developer if you get this error (hopefully you can reproduce it). Expected improvement was: " + EI + "predmean:" + predmean + " predvar" + predvar);
        }
        if (delta > this.POS103) {
            throw new IllegalStateException("Log-EI and EI have a difference " + delta + " expected it to be less than +10^-3. Please contact the developer if you get this error (hopefully you can reproduce it). Expected improvement was: " + EI + "predmean:" + predmean + " predvar" + predvar);
        }
    }
}

