/*
 * Decompiled with CFR 0.152.
 */
package org.mangosdk.spi.processor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.mangosdk.spi.processor.SpiProcessor;

public final class Options {
    static final String SPI_DISABLED_OPTION = "spi_disabled";
    static final String SPI_DIR_OPTION = "spi_dir";
    static final String SPI_LOG_OPTION = "spi_log";
    static final String SPI_VERBOSE_OPTION = "spi_verbose";
    private final List<String> warnings = new ArrayList<String>();
    private final boolean disabled;
    private final boolean log;
    private final boolean verbose;
    private final String dir;
    private final String report;

    public Options(Map<String, String> values) {
        this.disabled = this.getBooleanParameter(values, SPI_DISABLED_OPTION);
        this.log = this.getBooleanParameter(values, SPI_LOG_OPTION);
        this.verbose = this.getBooleanParameter(values, SPI_VERBOSE_OPTION);
        this.dir = Options.cleanPath(values.get(SPI_DIR_OPTION));
        this.report = this.createReport(values);
    }

    public boolean disabled() {
        return this.disabled;
    }

    public boolean verbose() {
        return this.verbose;
    }

    public boolean logging() {
        return this.log;
    }

    public String dir() {
        return this.dir;
    }

    public Collection<String> getWarnings() {
        return Collections.unmodifiableCollection(this.warnings);
    }

    public String report() {
        return this.report;
    }

    private String createReport(Map<String, String> values) {
        StringBuilder result = new StringBuilder();
        result.append("Initializing Annotation Processor ").append(SpiProcessor.NAME).append("\nUsed options:\n");
        this.writeOption(result, values, SPI_DISABLED_OPTION);
        this.writeOption(result, values, SPI_VERBOSE_OPTION);
        this.writeOption(result, values, SPI_LOG_OPTION);
        this.writeOption(result, values, SPI_DIR_OPTION);
        return result.toString();
    }

    private static String cleanPath(String path) {
        if (path == null) {
            return "";
        }
        String backSlashless = path.replace("\\", "/");
        if (backSlashless.endsWith("/")) {
            return backSlashless;
        }
        return backSlashless + "/";
    }

    private boolean getBooleanParameter(Map<String, String> values, String optionName) {
        if (!values.containsKey(optionName)) {
            return false;
        }
        String optionValue = values.get(optionName);
        if (optionValue == null || "true".equalsIgnoreCase(optionValue)) {
            return true;
        }
        if (!"false".equalsIgnoreCase(optionValue)) {
            this.warnings.add("Unrecognized value for parameter '" + optionName + "'. Found '" + optionValue + "'.  Legal values: 'true', 'false'.");
        }
        return false;
    }

    private void writeOption(StringBuilder result, Map<String, String> values, String optionName) {
        result.append(" - ").append(optionName).append(": ").append(this.optionMessage(values, optionName)).append("\n");
    }

    private String optionMessage(Map<String, String> values, String optionName) {
        if (values.containsKey(optionName)) {
            String optionValue = values.get(optionName);
            if (optionValue == null) {
                return "''";
            }
            return "'" + optionValue + "'";
        }
        return "missing";
    }
}

