/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.ablationanalysis;

import ca.ubc.cs.beta.ablationanalysis.AblationAnalysisTrajectoryEntry;
import ca.ubc.cs.beta.aeatk.algorithmexecutionconfiguration.AlgorithmExecutionOptions;
import ca.ubc.cs.beta.aeatk.logging.LogLevel;
import ca.ubc.cs.beta.aeatk.misc.jcommander.converter.BinaryDigitBooleanConverter;
import ca.ubc.cs.beta.aeatk.misc.jcommander.converter.OverallObjectiveConverter;
import ca.ubc.cs.beta.aeatk.misc.jcommander.converter.RunObjectiveConverter;
import ca.ubc.cs.beta.aeatk.misc.jcommander.validator.OneInfinityOpenInterval;
import ca.ubc.cs.beta.aeatk.misc.jcommander.validator.ZeroInfinityOpenInterval;
import ca.ubc.cs.beta.aeatk.misc.options.UsageTextField;
import ca.ubc.cs.beta.aeatk.objectives.OverallObjective;
import ca.ubc.cs.beta.aeatk.objectives.RunObjective;
import ca.ubc.cs.beta.aeatk.options.AbstractOptions;
import ca.ubc.cs.beta.aeatk.parameterconfigurationspace.ParameterConfiguration;
import ca.ubc.cs.beta.aeatk.parameterconfigurationspace.ParameterConfigurationSpace;
import ca.ubc.cs.beta.aeatk.probleminstance.ProblemInstanceOptions;
import ca.ubc.cs.beta.aeatk.random.SeedOptions;
import ca.ubc.cs.beta.aeatk.random.SeedableRandomPool;
import ca.ubc.cs.beta.aeatk.random.SeedableRandomPoolConstants;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterFile;
import com.beust.jcommander.ParametersDelegate;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@UsageTextField(title="Ablation Analysis Validation Options", description="General options for running validation on an ablation analysis trajectory", claimRequired={"--instanceFile"})
public class AblationAnalysisValidatorOptions
extends AbstractOptions {
    @Parameter(names={"--runObj", "--run_obj"}, description="per target algorithm run objective type that we are optimizing for", converter=RunObjectiveConverter.class, required=true)
    public RunObjective runObj;
    @Parameter(names={"--intraInstanceObj", "--overallObj", "--overall_obj", "--intra_instance_obj"}, description="objective function used to aggregate multiple runs for a single instance", converter=OverallObjectiveConverter.class, required=true)
    public OverallObjective intraInstanceObj;
    @Parameter(names={"--interInstanceObj", "--inter_instance_obj"}, description="objective function used to aggregate over multiple instances (that have already been aggregated under the Intra-Instance Objective)", converter=OverallObjectiveConverter.class)
    public OverallObjective interInstanceObj = OverallObjective.MEAN;
    @Parameter(names={"--maximumAblationRounds"}, description="Maximum number of ablation rounds to perform. Useful if you only care about the k most important parameters. If not set, will perform all necessary rounds between source and target.", required=false, validateWith=ZeroInfinityOpenInterval.class)
    public int maximumAblationRounds = -1;
    @Parameter(names={"--useRacing"}, description="If true, will use racing methods to accelerate ablation. If false, will perform brute-force ablation analysis.", required=false, converter=BinaryDigitBooleanConverter.class)
    public boolean useRacing = false;
    @Parameter(names={"--maximumRacingRounds"}, description="Maximum number of rounds to use when racing. If not set, will use the number of instances provided.", required=false, validateWith=OneInfinityOpenInterval.class)
    public int maximumRacingRounds = -1;
    @Parameter(names={"--racingRoundsBeforeFirstElimination"}, description="Number of racing rounds to perform before the first F-test is applied", required=false, validateWith=OneInfinityOpenInterval.class)
    public int racingRoundsBeforeFirstElimination = 5;
    @Parameter(names={"--sourceConfiguration"}, description="Source parameter configuration for ablation (In the same format calls are made to the algorithm) [Use 'DEFAULT' for the default]", required=true)
    public String sourceConfiguration;
    @Parameter(names={"--targetConfiguration"}, description="Target parameter configuration for ablation (In the same format calls are made to the algorithm) [Use 'DEFAULT' for the default]", required=true)
    public String targetConfiguration;
    @Parameter(names={"--targetRunsPerInstance"}, description="Number of target algorithm runs to perform for each problem instance", required=false, validateWith=ZeroInfinityOpenInterval.class)
    public int targetRunsPerInstance = 1;
    @ParametersDelegate
    public ProblemInstanceOptions instanceOptions = new ProblemInstanceOptions();
    @ParametersDelegate
    public AlgorithmExecutionOptions algoExecOptions = new AlgorithmExecutionOptions();
    @UsageTextField(defaultValues="<current working directory>")
    @Parameter(names={"--experimentDir", "-e"}, description="root directory for experiments Folder")
    public String experimentDir = new File(".").getAbsolutePath();
    @Parameter(names={"--consoleLogLevel"}, description="default log level of console output (this cannot be more verbose than the logLevel)")
    public LogLevel consoleLogLevel = LogLevel.INFO;
    @Parameter(names={"--logLevel"}, description="Log level for ablation analysis")
    public LogLevel logLevel = LogLevel.DEBUG;
    @ParametersDelegate
    public SeedOptions seedOptions = new SeedOptions();
    @Parameter(names={"--ablationLogFile"}, description="File containing the ablation log output you want to validate", required=true)
    public String ablationLogFile;
    @UsageTextField(defaultValues="")
    @Parameter(names={"--optionFile"}, description="file containing values for all ablation options.")
    @ParameterFile
    public File optionFile = null;
    @UsageTextField(defaultValues="", domain="")
    @Parameter(names={"--help", "-?", "/?", "-h"}, description="show help")
    public boolean showHelp = false;

    public ProblemInstanceOptions.TrainTestInstances getTrainingAndTestProblemInstances(SeedableRandomPool pool, boolean trainingRequired, boolean testingRequired) throws IOException {
        return this.instanceOptions.getTrainingAndTestProblemInstances(this.experimentDir, (long)pool.getRandom((Enum)SeedableRandomPoolConstants.INSTANCE_SEEDS).nextInt(), (long)pool.getRandom((Enum)SeedableRandomPoolConstants.TEST_SEED_INSTANCES).nextInt(), this.algoExecOptions.deterministic, trainingRequired, testingRequired, false, false);
    }

    public List<AblationAnalysisTrajectoryEntry> getAblationTrajectory() {
        File trajectoryFile = new File(this.ablationLogFile);
        ParameterConfigurationSpace space = this.algoExecOptions.paramFileDelegate.getParamConfigurationSpace();
        ParameterConfiguration source = space.getParameterConfigurationFromString(this.sourceConfiguration, ParameterConfiguration.ParameterStringFormat.NODB_OR_STATEFILE_SYNTAX);
        ParameterConfiguration target = space.getParameterConfigurationFromString(this.targetConfiguration, ParameterConfiguration.ParameterStringFormat.NODB_OR_STATEFILE_SYNTAX);
        ArrayList<AblationAnalysisTrajectoryEntry> trajectory = new ArrayList<AblationAnalysisTrajectoryEntry>();
        ArrayList<String> dummyFlipped = new ArrayList<String>();
        dummyFlipped.add("-source-");
        ArrayList<String> dummyVal = new ArrayList<String>();
        dummyVal.add("N/A");
        trajectory.add(new AblationAnalysisTrajectoryEntry(0, dummyFlipped, source, dummyVal, dummyVal));
        int numberOfRounds = -1;
        try {
            BufferedReader reader = new BufferedReader(new FileReader(trajectoryFile));
            Pattern totalRounds = Pattern.compile("Total number of rounds: ([0-9]*)");
            Pattern roundPattern = Pattern.compile("^Round ([0-9]*): Flipped (.*) from (.*) to (.*)$");
            Pattern configurationPattern = Pattern.compile("^Configuration : \"(.*)\"$");
            while (reader.ready()) {
                String line = reader.readLine();
                Matcher totalRoundsMatcher = totalRounds.matcher(line);
                if (!totalRoundsMatcher.matches()) continue;
                numberOfRounds = Integer.parseInt(totalRoundsMatcher.group(1));
                System.out.println("Found total rounds = " + numberOfRounds);
                break;
            }
            reader.readLine();
            int i = 1;
            while (i <= numberOfRounds) {
                String line = reader.readLine();
                Matcher roundMatcher = roundPattern.matcher(line);
                String otherLine = reader.readLine();
                Matcher configurationMatcher = configurationPattern.matcher(otherLine);
                if (roundMatcher.matches() && configurationMatcher.matches()) {
                    int round = Integer.parseInt(roundMatcher.group(1));
                    String paramsFlippedStr = roundMatcher.group(2);
                    String oldValues = roundMatcher.group(3);
                    String newValues = roundMatcher.group(4);
                    String[] params = paramsFlippedStr.split(", ");
                    String[] oldV = oldValues.split(", ");
                    String[] newV = newValues.split(", ");
                    ArrayList<String> flippedParamList = new ArrayList<String>();
                    ArrayList<String> oldValuesList = new ArrayList<String>();
                    ArrayList<String> newValuesList = new ArrayList<String>();
                    int j = 0;
                    while (j < params.length) {
                        flippedParamList.add(params[j]);
                        oldValuesList.add(oldV[j]);
                        newValuesList.add(newV[j]);
                        ++j;
                    }
                    String configuration = configurationMatcher.group(1);
                    if (round != i) {
                        System.err.println("ERROR: Expected round " + i + " but was " + round);
                    }
                    trajectory.add(new AblationAnalysisTrajectoryEntry(round, flippedParamList, space.getParameterConfigurationFromString(configuration, ParameterConfiguration.ParameterStringFormat.NODB_OR_STATEFILE_SYNTAX), oldValuesList, newValuesList));
                }
                ++i;
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("ERROR: Could not read trajectory file " + this.ablationLogFile);
        }
        catch (IOException e) {
            System.err.println("ERROR reading " + this.ablationLogFile + ": " + e.getMessage());
            e.printStackTrace();
        }
        ArrayList<String> targetFlipped = new ArrayList<String>();
        targetFlipped.add("-target-");
        trajectory.add(new AblationAnalysisTrajectoryEntry(numberOfRounds + 1, targetFlipped, target, dummyVal, dummyVal));
        return trajectory;
    }
}

