/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.ablationanalysis;

import ca.ubc.cs.beta.ablationanalysis.AblationAnalysisTrajectoryEntry;
import ca.ubc.cs.beta.ablationanalysis.AblationAnalysisValidatorOptions;
import ca.ubc.cs.beta.aeatk.algorithmexecutionconfiguration.AlgorithmExecutionConfiguration;
import ca.ubc.cs.beta.aeatk.algorithmrunconfiguration.AlgorithmRunConfiguration;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.AlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.misc.associatedvalue.Pair;
import ca.ubc.cs.beta.aeatk.objectives.OverallObjective;
import ca.ubc.cs.beta.aeatk.objectives.RunObjective;
import ca.ubc.cs.beta.aeatk.parameterconfigurationspace.ParameterConfiguration;
import ca.ubc.cs.beta.aeatk.probleminstance.ProblemInstance;
import ca.ubc.cs.beta.aeatk.probleminstance.ProblemInstanceSeedPair;
import ca.ubc.cs.beta.aeatk.probleminstance.seedgenerator.InstanceSeedGenerator;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorCallback;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.WaitableTAECallback;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;

public class AblationAnalysisValidator {
    public AblationAnalysisValidationResult validate(TargetAlgorithmEvaluator evaluator, AlgorithmExecutionConfiguration executionConfiguration, List<AblationAnalysisTrajectoryEntry> trajectory, List<ProblemInstance> instances, InstanceSeedGenerator generator, AblationAnalysisValidatorOptions options) {
        int numRunsPerInstance = options.targetRunsPerInstance;
        List reorderedInstances = generator.getProblemInstanceOrder(instances);
        ArrayList<ProblemInstanceSeedPair> instanceSeedPairs = new ArrayList<ProblemInstanceSeedPair>(instances.size() * numRunsPerInstance);
        final RunObjective runObjective = options.runObj;
        OverallObjective intraInstanceObj = options.intraInstanceObj;
        OverallObjective interInstanceObj = options.interInstanceObj;
        ArrayList<Pair<AblationAnalysisTrajectoryEntry, Double>> resultsPerRound = new ArrayList<Pair<AblationAnalysisTrajectoryEntry, Double>>();
        int i = 0;
        while (i < instances.size()) {
            ProblemInstance instance = (ProblemInstance)reorderedInstances.get(i);
            int j = 0;
            while (j < numRunsPerInstance) {
                instanceSeedPairs.add(new ProblemInstanceSeedPair(instance, (long)generator.getNextSeed(instance)));
                ++j;
            }
            ++i;
        }
        for (AblationAnalysisTrajectoryEntry trajEntry : trajectory) {
            ParameterConfiguration config = trajEntry.resultingConfiguration;
            final ConcurrentHashMap results = new ConcurrentHashMap();
            ArrayList<AlgorithmRunConfiguration> runs = new ArrayList<AlgorithmRunConfiguration>();
            final AtomicReference exception = new AtomicReference();
            WaitableTAECallback callback = new WaitableTAECallback(new TargetAlgorithmEvaluatorCallback(){

                public void onSuccess(List<AlgorithmRunResult> runs) {
                    for (AlgorithmRunResult run : runs) {
                        ParameterConfiguration config = run.getAlgorithmRunConfiguration().getParameterConfiguration();
                        ProblemInstanceSeedPair instanceSeed = run.getAlgorithmRunConfiguration().getProblemInstanceSeedPair();
                        ProblemInstance instance = instanceSeed.getProblemInstance();
                        double value = runObjective.getObjective(run);
                        List resultList = (List)results.get(instance);
                        resultList.add(value);
                    }
                }

                public void onFailure(RuntimeException e) {
                    exception.set(e);
                }
            });
            for (ProblemInstanceSeedPair instanceSeed : instanceSeedPairs) {
                List resultEntry = (List)results.get(instanceSeed.getProblemInstance());
                if (resultEntry == null) {
                    results.put(instanceSeed.getProblemInstance(), new ArrayList());
                }
                AlgorithmRunConfiguration run = new AlgorithmRunConfiguration(instanceSeed, options.algoExecOptions.cutoffTime, config, executionConfiguration);
                runs.add(run);
            }
            evaluator.evaluateRunsAsync(runs, (TargetAlgorithmEvaluatorCallback)callback);
            callback.waitForCompletion();
            ArrayList<Double> aggregatedInstanceResults = new ArrayList<Double>();
            for (ProblemInstance instance : reorderedInstances) {
                List instanceResults = (List)results.get(instance);
                double aggregated = intraInstanceObj.aggregate((Collection)instanceResults, options.algoExecOptions.cutoffTime);
                aggregatedInstanceResults.add(aggregated);
                System.out.printf("Results on instance %s were over %d runs\n", instance.toString(), instanceResults.size());
            }
            double finalResult = interInstanceObj.aggregate(aggregatedInstanceResults, options.algoExecOptions.cutoffTime);
            resultsPerRound.add((Pair<AblationAnalysisTrajectoryEntry, Double>)new Pair((Object)trajEntry, (Object)finalResult));
        }
        AblationAnalysisValidationResult res = new AblationAnalysisValidationResult();
        res.validationResults = resultsPerRound;
        return res;
    }

    public class AblationAnalysisValidationResult {
        public List<Pair<AblationAnalysisTrajectoryEntry, Double>> validationResults;
    }
}

