/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.ablationanalysis;

import ca.ubc.cs.beta.ablationanalysis.AblationAnalysis;
import ca.ubc.cs.beta.ablationanalysis.AblationAnalysisExecutorOptions;
import ca.ubc.cs.beta.ablationanalysis.AblationAnalysisOptions;
import ca.ubc.cs.beta.aeatk.algorithmexecutionconfiguration.AlgorithmExecutionConfiguration;
import ca.ubc.cs.beta.aeatk.misc.jcommander.JCommanderHelper;
import ca.ubc.cs.beta.aeatk.options.AbstractOptions;
import ca.ubc.cs.beta.aeatk.options.docgen.OptionsToUsage;
import ca.ubc.cs.beta.aeatk.options.docgen.UsageSectionGenerator;
import ca.ubc.cs.beta.aeatk.parameterconfigurationspace.ParameterConfiguration;
import ca.ubc.cs.beta.aeatk.parameterconfigurationspace.ParameterConfigurationSpace;
import ca.ubc.cs.beta.aeatk.probleminstance.ProblemInstanceOptions;
import ca.ubc.cs.beta.aeatk.probleminstance.seedgenerator.InstanceSeedGenerator;
import ca.ubc.cs.beta.aeatk.probleminstance.seedgenerator.RandomInstanceSeedGenerator;
import ca.ubc.cs.beta.aeatk.random.SeedableRandomPool;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorOptions;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.init.TargetAlgorithmEvaluatorBuilder;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.init.TargetAlgorithmEvaluatorLoader;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AblationAnalysisExecutor {
    private static Logger log;
    private static Map<String, AbstractOptions> taeOptions;

    public static void main(String[] args) {
        AblationAnalysisExecutorOptions options = AblationAnalysisExecutor.parseCommandLineOptions(args);
        SeedableRandomPool pool = options.seedOptions.getSeedableRandomPool();
        try {
            ProblemInstanceOptions.TrainTestInstances tti = options.getTrainingAndTestProblemInstances(pool, true, false);
            List training = tti.getTrainingInstances().getInstances();
            ParameterConfigurationSpace configurationSpace = options.algoExecOptions.paramFileDelegate.getParamConfigurationSpace();
            ParameterConfiguration sourceConfiguration = configurationSpace.getParameterConfigurationFromString(options.sourceConfiguration, ParameterConfiguration.ParameterStringFormat.NODB_OR_STATEFILE_SYNTAX, null);
            ParameterConfiguration targetConfiguration = configurationSpace.getParameterConfigurationFromString(options.targetConfiguration, ParameterConfiguration.ParameterStringFormat.NODB_OR_STATEFILE_SYNTAX, null);
            RandomInstanceSeedGenerator generator = new RandomInstanceSeedGenerator(training, (long)options.seedOptions.numRun);
            AblationAnalysisOptions ablationOptions = new AblationAnalysisOptions();
            ablationOptions.cutoffTime = options.algoExecOptions.cutoffTime;
            ablationOptions.maximumAblationRounds = options.maximumAblationRounds;
            ablationOptions.useRacing = options.useRacing;
            ablationOptions.maximumRacingRounds = options.maximumRacingRounds;
            ablationOptions.racingRoundsBeforeFirstElimination = options.racingRoundsBeforeFirstElimination;
            ablationOptions.runObj = options.runObj;
            ablationOptions.intraInstanceObj = options.intraInstanceObj;
            ablationOptions.interInstanceObj = options.interInstanceObj;
            AlgorithmExecutionConfiguration executionConfiguration = options.algoExecOptions.getAlgorithmExecutionConfig(options.experimentDir);
            TargetAlgorithmEvaluator tae = TargetAlgorithmEvaluatorBuilder.getTargetAlgorithmEvaluator((TargetAlgorithmEvaluatorOptions)options.algoExecOptions.taeOpts, (boolean)true, (boolean)true, taeOptions, null);
            try {
                AblationAnalysis.AblationAnalysisResult result = new AblationAnalysis().doAblationAnalysis(tae, executionConfiguration, configurationSpace, sourceConfiguration, targetConfiguration, training, (InstanceSeedGenerator)generator, ablationOptions);
                List<List<String>> flippedParamsPerRound = result.flippedParametersPerRound;
                List<ParameterConfiguration> configs = result.resultingConfigurationPerRound;
                log.info("Ablation complete.");
                log.info("Total number of rounds: {}", (Object)(flippedParamsPerRound.size() - 1));
                log.info("Specifics:");
                int i = 1;
                while (i < flippedParamsPerRound.size()) {
                    List<String> params = flippedParamsPerRound.get(i);
                    ParameterConfiguration config = configs.get(i);
                    StringBuffer paramBuf = new StringBuffer();
                    StringBuffer sourceBuf = new StringBuffer();
                    StringBuffer targetBuf = new StringBuffer();
                    boolean first = true;
                    for (String p : params) {
                        if (!first) {
                            paramBuf.append(", ");
                            sourceBuf.append(", ");
                            targetBuf.append(", ");
                        }
                        first = false;
                        paramBuf.append(p);
                        sourceBuf.append(sourceConfiguration.get((Object)p));
                        targetBuf.append(targetConfiguration.get((Object)p));
                    }
                    log.info("Round {}: Flipped {} from {} to {}", new Object[]{i, paramBuf, sourceBuf, targetBuf});
                    log.info("Configuration : \"{}\"", (Object)config.getFormattedParameterString(ParameterConfiguration.ParameterStringFormat.NODB_SYNTAX));
                    ++i;
                }
            }
            finally {
                tae.notifyShutdown();
            }
        }
        catch (IOException e) {
            log.error(e.getMessage());
        }
    }

    protected static AblationAnalysisExecutorOptions parseCommandLineOptions(String[] args) {
        taeOptions = TargetAlgorithmEvaluatorLoader.getAvailableTargetAlgorithmEvaluators();
        AblationAnalysisExecutorOptions options = new AblationAnalysisExecutorOptions();
        JCommander jcom = JCommanderHelper.getJCommander((AbstractOptions)options, taeOptions);
        jcom.setProgramName("ablationAnalysis");
        AblationAnalysisExecutor.checkArgsForUsageScreenValues(args, options);
        jcom.parse(args);
        System.setProperty("OUTPUTDIR", "./log/");
        System.setProperty("NUMRUN", String.valueOf(options.seedOptions.numRun));
        System.setProperty("STDOUT-LEVEL", options.consoleLogLevel.name());
        System.setProperty("ROOT-LEVEL", options.logLevel.name());
        String logLocation = "." + File.separator + "log" + File.separator;
        System.out.println("*****************************\nLogging to: " + logLocation + "\n*****************************");
        log = LoggerFactory.getLogger(AblationAnalysisExecutor.class);
        return options;
    }

    private static void checkArgsForUsageScreenValues(String[] args, AblationAnalysisExecutorOptions config) {
        try {
            String[] helpNames;
            HashSet<String> possibleValues = new HashSet<String>(Arrays.asList(args));
            String[] stringArray = helpNames = ((Object)((Object)config)).getClass().getField("showHelp").getAnnotation(Parameter.class).names();
            int n = helpNames.length;
            int n2 = 0;
            while (n2 < n) {
                String helpName = stringArray[n2];
                if (possibleValues.contains(helpName)) {
                    OptionsToUsage.usage((List)UsageSectionGenerator.getUsageSections((Object)((Object)config), taeOptions));
                    System.exit(0);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

