/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.ablationanalysis;

import ca.ubc.cs.beta.ablationanalysis.AblationAnalysisOptions;
import ca.ubc.cs.beta.aeatk.algorithmexecutionconfiguration.AlgorithmExecutionConfiguration;
import ca.ubc.cs.beta.aeatk.algorithmrunconfiguration.AlgorithmRunConfiguration;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.AlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.eventsystem.EventManager;
import ca.ubc.cs.beta.aeatk.eventsystem.events.AutomaticConfiguratorEvent;
import ca.ubc.cs.beta.aeatk.objectives.RunObjective;
import ca.ubc.cs.beta.aeatk.parameterconfigurationspace.ParameterConfiguration;
import ca.ubc.cs.beta.aeatk.parameterconfigurationspace.ParameterConfigurationSpace;
import ca.ubc.cs.beta.aeatk.probleminstance.ProblemInstance;
import ca.ubc.cs.beta.aeatk.probleminstance.ProblemInstanceSeedPair;
import ca.ubc.cs.beta.aeatk.probleminstance.seedgenerator.InstanceSeedGenerator;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorCallback;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.WaitableTAECallback;
import ca.ubc.cs.beta.racing.FRace;
import ca.ubc.cs.beta.racing.FRaceOptions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AblationAnalysis {
    private static Logger log = LoggerFactory.getLogger(AblationAnalysis.class);
    private EventManager eventManager;

    public void setEventManager(EventManager e) {
        this.eventManager = e;
    }

    public AblationAnalysisResult doAblationAnalysis(TargetAlgorithmEvaluator evaluator, AlgorithmExecutionConfiguration executionConfiguration, ParameterConfigurationSpace parameterSpace, ParameterConfiguration sourceConfiguration, ParameterConfiguration targetConfiguration, List<ProblemInstance> instances, InstanceSeedGenerator instanceSeedGenerator, AblationAnalysisOptions options) {
        if (this.eventManager == null) {
            this.setEventManager(new EventManager());
        }
        boolean useRacing = options.useRacing;
        FRaceOptions raceOptions = new FRaceOptions();
        raceOptions.cutoffTime = options.cutoffTime;
        raceOptions.maximumRacingRounds = options.maximumRacingRounds;
        raceOptions.racingRoundsBeforeFirstElimination = options.racingRoundsBeforeFirstElimination;
        raceOptions.runObj = options.runObj;
        raceOptions.intraInstanceObj = options.intraInstanceObj;
        raceOptions.interInstanceObj = options.interInstanceObj;
        HashSet<String> flippableParameters = new HashSet<String>();
        for (String param : parameterSpace.getParameterNames()) {
            boolean activeInSource = sourceConfiguration.getActiveParameters().contains(param);
            boolean activeInTarget = targetConfiguration.getActiveParameters().contains(param);
            String sourceValue = sourceConfiguration.get((Object)param);
            String targetValue = targetConfiguration.get((Object)param);
            if ((activeInSource || !activeInTarget) && (!activeInSource || sourceValue.equals(targetValue))) continue;
            if (!activeInSource && activeInTarget && targetConfiguration.get((Object)param).equals(parameterSpace.getDefaultConfiguration().get((Object)param))) {
                log.info("{} was not active in source, and had the default value in the target. Treating as unchanged.", (Object)param);
                continue;
            }
            flippableParameters.add(param);
        }
        HashMap dependentParametersPerParameter = new HashMap();
        for (String param : flippableParameters) {
            Set parents = parameterSpace.getAllParentParameters(param);
            if (parents == null) continue;
            ArrayList<String> dependentFlippable = new ArrayList<String>();
            for (String p : parents) {
                if (!flippableParameters.contains(p)) continue;
                dependentFlippable.add(p);
            }
            if (dependentFlippable.size() <= 0) continue;
            dependentParametersPerParameter.put(param, dependentFlippable);
            log.info("{} depends on the value of {} before it can be flipped. They may be treated as a group.", (Object)param, dependentFlippable);
        }
        int numberOfFlippableParameters = flippableParameters.size();
        log.info("Performing ablation analysis.");
        if (useRacing) {
            log.info("Using F-Race to accelerate each ablation round.");
            log.info("\tMaximum number of racing rounds: {}", (Object)options.maximumRacingRounds);
            log.info("\tInitial rounds before the first F-test: {}", (Object)options.racingRoundsBeforeFirstElimination);
        } else {
            log.info("No racing. Using brute-force ablation.");
        }
        log.info("Number of problem instances: {}", (Object)instances.size());
        log.info("Source configuration: {}", (Object)sourceConfiguration.getFormattedParameterString(ParameterConfiguration.ParameterStringFormat.NODB_SYNTAX));
        log.info("Target configuration: {}", (Object)targetConfiguration.getFormattedParameterString(ParameterConfiguration.ParameterStringFormat.NODB_SYNTAX));
        log.info("{} flippable parameters:", (Object)numberOfFlippableParameters);
        for (String param : flippableParameters) {
            boolean activeInSource = sourceConfiguration.getActiveParameters().contains(param);
            boolean activeInTarget = targetConfiguration.getActiveParameters().contains(param);
            log.info("\t{} : {} -> {}", new Object[]{param, activeInSource ? sourceConfiguration.get((Object)param) : "not active", activeInTarget ? targetConfiguration.get((Object)param) : "not active"});
        }
        int roundsPerformed = 0;
        ArrayList<List<String>> flippedParameters = new ArrayList<List<String>>(numberOfFlippableParameters + 1);
        ArrayList<ParameterConfiguration> roundWinners = new ArrayList<ParameterConfiguration>(numberOfFlippableParameters + 1);
        flippedParameters.add(0, new ArrayList());
        roundWinners.add(0, sourceConfiguration);
        int currentRound = 1;
        while (currentRound <= numberOfFlippableParameters && flippableParameters.size() > 0 && (options.maximumAblationRounds < 0 || currentRound <= options.maximumAblationRounds)) {
            ParameterConfiguration previousWinner = (ParameterConfiguration)roundWinners.get(currentRound - 1);
            HashMap configurationToFlippedParams = new HashMap();
            HashSet<ParameterConfiguration> allRoundConfigurations = new HashSet<ParameterConfiguration>(flippableParameters.size());
            for (String param : flippableParameters) {
                String targetValueForParam = targetConfiguration.get((Object)param);
                ParameterConfiguration neighbour = new ParameterConfiguration(previousWinner);
                ArrayList flipped = new ArrayList();
                if (!neighbour.getActiveParameters().contains(param) && targetConfiguration.getActiveParameters().contains(param)) {
                    List deps = (List)dependentParametersPerParameter.get(param);
                    HashSet<String> flippedDeps = new HashSet<String>();
                    int numSet = 0;
                    while (numSet != deps.size()) {
                        numSet = 0;
                        for (String d : deps) {
                            if (!neighbour.getActiveParameters().contains(d)) continue;
                            if (neighbour.get((Object)d) != targetConfiguration.get((Object)d)) {
                                neighbour.put(d, targetConfiguration.get((Object)d));
                                flippedDeps.add(d);
                            }
                            ++numSet;
                        }
                    }
                    flipped.addAll(flippedDeps);
                }
                neighbour.put(param, targetValueForParam);
                if (!flipped.contains(param)) {
                    flipped.add(param);
                }
                if (allRoundConfigurations.contains(neighbour)) continue;
                configurationToFlippedParams.put(neighbour, flipped);
                allRoundConfigurations.add(neighbour);
            }
            ArrayList configurationsInThisRound = new ArrayList(allRoundConfigurations);
            if (configurationsInThisRound.size() > 1) {
                instanceSeedGenerator.reinit();
                if (useRacing) {
                    FRace race = new FRace();
                    race.setEventManager(this.eventManager);
                    raceOptions.seed = options.seed + (long)currentRound;
                    FRace.FRaceResult result = race.doRace(evaluator, executionConfiguration, configurationsInThisRound, instances, instanceSeedGenerator, raceOptions);
                    List flippedParams = (List)configurationToFlippedParams.get(result.selectedConfiguration);
                    flippableParameters.removeAll(flippedParams);
                    flippedParameters.add(currentRound, flippedParams);
                    roundWinners.add(currentRound, result.selectedConfiguration);
                    log.info("Ablation Round {}: Flipped parameter(s) {} to achieve reported quality {}.", new Object[]{currentRound, flippedParams, result.approximatePerformance});
                } else {
                    Random rand = new Random(options.seed);
                    final RunObjective runObjective = options.runObj;
                    double cutoffTime = options.cutoffTime;
                    List reorderedInstances = instanceSeedGenerator.getProblemInstanceOrder(instances);
                    ArrayList<ProblemInstanceSeedPair> instanceSeedPairs = new ArrayList<ProblemInstanceSeedPair>(reorderedInstances.size());
                    int i = 0;
                    while (i < reorderedInstances.size()) {
                        ProblemInstance inst = (ProblemInstance)reorderedInstances.get(i);
                        instanceSeedPairs.add(new ProblemInstanceSeedPair(inst, (long)instanceSeedGenerator.getNextSeed(inst)));
                        ++i;
                    }
                    final ConcurrentHashMap results = new ConcurrentHashMap();
                    for (ParameterConfiguration conf : configurationsInThisRound) {
                        results.put(conf, new ConcurrentHashMap());
                    }
                    final int round = currentRound;
                    final AtomicReference exception = new AtomicReference();
                    WaitableTAECallback callback = new WaitableTAECallback(new TargetAlgorithmEvaluatorCallback(){

                        public void onSuccess(List<AlgorithmRunResult> runs) {
                            for (AlgorithmRunResult run : runs) {
                                ParameterConfiguration config = run.getAlgorithmRunConfiguration().getParameterConfiguration();
                                ProblemInstance inst = run.getAlgorithmRunConfiguration().getProblemInstanceSeedPair().getProblemInstance();
                                double value = runObjective.getObjective(run);
                                ((ConcurrentMap)results.get(config)).put(inst, value);
                            }
                        }

                        public void onFailure(RuntimeException e) {
                            log.warn("Ablation Round {}: \t.onFailure() triggered in callback. Exception was: {}", new Object[]{round, e.getMessage()});
                            exception.set(e);
                        }
                    });
                    ArrayList<AlgorithmRunConfiguration> runs = new ArrayList<AlgorithmRunConfiguration>();
                    for (ProblemInstanceSeedPair instanceSeed : instanceSeedPairs) {
                        for (ParameterConfiguration config : configurationsInThisRound) {
                            AlgorithmRunConfiguration run = new AlgorithmRunConfiguration(instanceSeed, cutoffTime, config, executionConfiguration);
                            runs.add(run);
                        }
                    }
                    log.info("Ablation Round {}: calling evaluateRunsAsync() with {} runs", new Object[]{round, runs.size()});
                    evaluator.evaluateRunsAsync(runs, (TargetAlgorithmEvaluatorCallback)callback);
                    callback.waitForCompletion();
                    ParameterConfiguration best = null;
                    double bestPerformance = -1.0;
                    for (ParameterConfiguration config : configurationsInThisRound) {
                        ConcurrentMap perf = (ConcurrentMap)results.get(config);
                        ArrayList<Double> objValues = new ArrayList<Double>();
                        for (Map.Entry entry : perf.entrySet()) {
                            objValues.add((Double)entry.getValue());
                        }
                        double performance = options.interInstanceObj.aggregate(objValues, cutoffTime);
                        log.info("Ablation Round {}: aggregate performance of {} was {}", new Object[]{round, config, performance});
                        if (best != null && !(performance < bestPerformance)) continue;
                        best = config;
                        bestPerformance = performance;
                    }
                    List flippedParams = (List)configurationToFlippedParams.get(best);
                    flippableParameters.removeAll(flippedParams);
                    flippedParameters.add(currentRound, flippedParams);
                    roundWinners.add(currentRound, best);
                    log.info("Ablation Round {}: Flipped parameter(s) {} to achieve reported quality {}.", new Object[]{currentRound, flippedParams, bestPerformance});
                }
            } else if (configurationsInThisRound.size() == 1) {
                ParameterConfiguration winner = (ParameterConfiguration)configurationsInThisRound.get(0);
                List flippedParams = (List)configurationToFlippedParams.get(winner);
                flippableParameters.removeAll(flippedParams);
                flippedParameters.add(currentRound, flippedParams);
                roundWinners.add(currentRound, winner);
                log.info("Ablation Round {}: Flipped parameter(s) {} to achieve reported quality {}.", new Object[]{currentRound, flippedParams, "Not measured"});
            } else {
                log.error("0 configurations...");
                log.error("Previous winner: " + previousWinner.hashCode() + " : " + previousWinner.getFormattedParameterString(ParameterConfiguration.ParameterStringFormat.NODB_SYNTAX));
                log.error("Source: " + sourceConfiguration.hashCode() + " : " + sourceConfiguration.getFormattedParameterString(ParameterConfiguration.ParameterStringFormat.NODB_SYNTAX));
                log.error("Target: " + targetConfiguration.hashCode() + " : " + targetConfiguration.getFormattedParameterString(ParameterConfiguration.ParameterStringFormat.NODB_SYNTAX));
                throw new IllegalStateException("0 configurations in ablation round " + currentRound + "!!!!");
            }
            ++roundsPerformed;
            ArrayList<List<String>> flips = new ArrayList<List<String>>(flippedParameters.size());
            int i = 0;
            while (i < flippedParameters.size()) {
                List roundFlips = (List)flippedParameters.get(i);
                ArrayList<String> l = new ArrayList<String>(((List)flippedParameters.get(i)).size());
                int j = 0;
                while (j < roundFlips.size()) {
                    l.add(j, (String)roundFlips.get(j));
                    ++j;
                }
                flips.add(i, l);
                ++i;
            }
            ArrayList<ParameterConfiguration> chosenConfigs = new ArrayList<ParameterConfiguration>(roundWinners.size());
            int i2 = 0;
            while (i2 < roundWinners.size()) {
                chosenConfigs.add(i2, (ParameterConfiguration)roundWinners.get(i2));
                ++i2;
            }
            AblationAnalysisResult currentResult = new AblationAnalysisResult();
            currentResult.numberOfFlippableParameters = numberOfFlippableParameters;
            currentResult.roundsPerformed = roundsPerformed;
            currentResult.maximumRounds = numberOfFlippableParameters;
            currentResult.flippedParametersPerRound = flips;
            currentResult.resultingConfigurationPerRound = chosenConfigs;
            AblationAnalysisRoundFinishedEvent event = new AblationAnalysisRoundFinishedEvent();
            event.currentResult = currentResult;
            this.eventManager.fireEvent((AutomaticConfiguratorEvent)event);
            ++currentRound;
        }
        AblationAnalysisResult result = new AblationAnalysisResult();
        result.numberOfFlippableParameters = numberOfFlippableParameters;
        result.roundsPerformed = roundsPerformed;
        result.maximumRounds = roundsPerformed;
        result.flippedParametersPerRound = flippedParameters;
        result.resultingConfigurationPerRound = roundWinners;
        this.eventManager.flush();
        return result;
    }

    public class AblationAnalysisResult {
        public int numberOfFlippableParameters;
        public int roundsPerformed;
        public int maximumRounds;
        public List<List<String>> flippedParametersPerRound;
        public List<ParameterConfiguration> resultingConfigurationPerRound;
    }

    public class AblationAnalysisRoundFinishedEvent
    extends AutomaticConfiguratorEvent {
        public AblationAnalysisResult currentResult;
    }
}

