function [data] = crfChain_prepareDataTest(trainData,Xtest,ytest)

data = trainData; % By default copy everything

% Update Features
data.nWords = int32(size(Xtest,1)); % Number of words can be different
if data.addBias;
    data.addBias = 1;
    Xtest = [ones(data.nWords,1) Xtest];
end
for f = 1:length(data.nFeatures)
   ind = find(Xtest(:,f) > data.nFeatures(f));
   if ~isempty(ind)
       fprintf('Zeroing feature that did not occur during training');
       Xtest(ind,f) = 0; % Set features to zero if outside range from training data
   end
end
data.X = int32(Xtest);

% Update Labels
if any(ytest > data.nStates)
    fprintf('Warning: test data includes a label that was not in training data\n');
end
data.y = int32(ytest);

% Update sentences
data.sentences = int32(crfChain_initSentences(ytest));
data.maxSentenceLength = int32(1+max(data.sentences(:,2)-data.sentences(:,1)));