function [data,wv] = crfChain_prepareData(X,y,addBias)

data.nWords = int32(size(X,1));
if addBias
    data.addBias = 1;
    X = [ones(data.nWords,1) X];
end
data.X = int32(X);
data.y = int32(y);
data.nStates = int32(max(y));
nFeatures = max(X);
data.featureStart = int32(cumsum([1 nFeatures(1:end)]));
data.nFeatures = int32(nFeatures);
data.sentences = int32(crfChain_initSentences(y));
data.maxSentenceLength = int32(1+max(data.sentences(:,2)-data.sentences(:,1)));
[w,v_start,v_end,v] = crfChain_initWeights(data.nFeatures,data.nStates);
data.nNodeParams = int32(length(w));
wv = [w(:);v_start(:);v_end(:);v(:)];
data.nParams = int32(length(wv));