#include <math.h>
#include "mex.h"

#define all_n n = 0; n < nNodes; n++
#define all_state state = 0; state < nStates; state++
#define all_state1 state1 = 0; state1 < nStates; state1++
#define all_state2 state2 = 0; state2 < nStates; state2++
#define all_features f = 0; f < nFeatureTypes; f++
#define nodePot(a,b) nodePot[a + nNodes*(b)]
#define edgePot(a,b) edgePot[a + nStates*(b)]
#define nodeBel(a,b) nodeBel[a + nNodes*(b)]
#define edgeBel(a,b,c) edgeBel[a + nStates*(b + nStates*(c))]
#define alpha(a,b) alpha[a + nNodes*(b)]
#define beta(a,b) beta[a + nNodes*(b)]
#define tmp(a,b) tmp[a + nStates*(b)]
#define v(a,b) v[a + nStates*(b)]
#define dV(a,b) dV[a + nStates*(b)]
#define NB(a,b) NB[a + nWords*(b)]
#define EB(a,b,c) EB[a + nStates*(b + nStates*(c))]

int maxVal(int x,int y) {
    if(x >= y)
        return x;
    else
        return y;
}

void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[]) {
    int n,s,state,state1,state2,nStates,nNodes,*sentences,nSentences,maxSentenceLength;
    int f,feature,featureInd,*nFeatures,nFeatureTypes,nFeaturesTotal,*featureStart,nParams;
    int *X,*y,nWords;
    int iter,*iVals,maxIter,nCovered, *lastVisited,  *covered, ind;
    double *wv,*nodePot,*nodeBel,*edgePot,*edgeBel,*alpha,*beta,*tmp,*w,*v_start,*v_end,*v,Z,logZ,*kappa;
    double lambda, stepSize, rho=1.0, step, *cumSum, *d,*dW,*dV_start,*dV_end,*dV,*NB,*EB;
    mxArray *mxA;
        
    if (nrhs != 9)
        mexErrMsgTxt("9 arguments are needed: {wv,data,lambda,stepSizes,iVals,d,covered,NB,EB}");
    
    
    /* Process optimization arguments */
    lambda = mxGetScalar(prhs[2]);
    stepSize = mxGetScalar(prhs[3]);
    iVals = (int*)mxGetPr(prhs[4]);
    d = mxGetPr(prhs[5]);
    covered = (int*)mxGetPr(prhs[6]);
    NB = mxGetPr(prhs[7]);
    EB = mxGetPr(prhs[8]);
    maxIter = maxVal(mxGetM(prhs[4]),mxGetN(prhs[4]));
    if (!mxIsClass(prhs[4],"int32") || !mxIsClass(prhs[6],"int32"))
        mexErrMsgTxt("iVals and covered must be int32");
    
    /* ******************************
     * Process data struct 
     ******************************** */
    if (!mxIsStruct(prhs[1]))
        mexErrMsgTxt("data argument needs to be a struct");
    
    mxA = mxGetField(prhs[1],0,"X");
    X = (int*)mxGetPr(mxA);
    nWords = mxGetM(mxA);
    
    y = (int*)mxGetPr(mxGetField(prhs[1],0,"y"));
    
    nStates = (int)mxGetScalar(mxGetField(prhs[1],0,"nStates"));
    
    mxA = mxGetField(prhs[1],0,"sentences");
    sentences = (int*)mxGetPr(mxA);
    nSentences = mxGetM(mxA);
    
    maxSentenceLength = (int)mxGetScalar(mxGetField(prhs[1],0,"maxSentenceLength"));
    
    featureStart = (int*)mxGetPr(mxGetField(prhs[1],0,"featureStart"));
    
    mxA = mxGetField(prhs[1],0,"nFeatures");
    nFeatures = (int*)mxGetPr(mxA);
    nFeatureTypes = maxVal(mxGetM(mxA),mxGetN(mxA));
    nFeaturesTotal = featureStart[nFeatureTypes]-1;
    nParams = nFeaturesTotal*nStates + nStates + nStates + nStates*nStates;
    
    /* Error Checking for sizes of NB and EB */
    if (nWords != mxGetM(prhs[7]))
        mexErrMsgTxt("X and NB must have the same number of rows");
    if (nStates != mxGetN(prhs[7]))
        mexErrMsgTxt("NB must have nStates columns");
    if (3 != mxGetNumberOfDimensions(prhs[8]))
        mexErrMsgTxt("EB must be a 3D array");
    if (nStates != mxGetDimensions(prhs[8])[0])
        mexErrMsgTxt("EB must have nStates rows");
    if (nStates != mxGetDimensions(prhs[8])[1])
        mexErrMsgTxt("EB must have nStates columns");
    if (nSentences != mxGetDimensions(prhs[8])[2])
        mexErrMsgTxt("EB must be (nStates,nStates,nSentences)");
    
    /* ******************************
     * Initialize intermediate values
     ******************************** */
    nodePot = mxCalloc(maxSentenceLength*nStates,sizeof(double));
    edgePot = mxCalloc(nStates*nStates,sizeof(double));
    nodeBel = mxCalloc(maxSentenceLength*nStates,sizeof(double));
    edgeBel = mxCalloc(maxSentenceLength*nStates*nStates,sizeof(double));
    alpha = mxCalloc(maxSentenceLength*nStates,sizeof(double));
    beta = mxCalloc(maxSentenceLength*nStates,sizeof(double));
    tmp = mxCalloc(nStates*nStates,sizeof(double));
    kappa = mxCalloc(maxSentenceLength,sizeof(double));
    
    lastVisited = mxCalloc(nFeaturesTotal*nStates,sizeof(int));
    cumSum = mxCalloc(maxIter,sizeof(double));
    
    nCovered = 0;
    for(s = 0;s < nSentences;s++) {
        if (covered[s]!=0)
            nCovered++;
    }
    wv = mxGetPr(prhs[0]);
    w = wv;
    v_start = &wv[nFeaturesTotal*nStates];
    v_end = &wv[nFeaturesTotal*nStates + nStates];
    v = &wv[nFeaturesTotal*nStates + nStates + nStates];
    
    dW = d;
    dV_start = &d[nFeaturesTotal*nStates];
    dV_end = &d[nFeaturesTotal*nStates + nStates];
    dV = &d[nFeaturesTotal*nStates + nStates + nStates];
                
    if(maxVal(mxGetM(prhs[0]),mxGetN(prhs[0])) != maxVal(mxGetM(prhs[5]),mxGetN(prhs[5])))
        mexErrMsgTxt("wv and d must have the same length");
    if(nSentences != maxVal(mxGetM(prhs[6]),mxGetN(prhs[6])))
        mexErrMsgTxt("nCovered must length equal to nSentences");
    
    if (stepSize*lambda == 1)
        mexErrMsgTxt("Sorry, I don't like it when Xt is sparse and alpha*lambda=1");
    
    for(iter=0; iter < maxIter; iter++) {
        s = iVals[iter]-1;
           
        /* Compute node potentials */
        nNodes = sentences[s + nSentences]-sentences[s]+1;
        /* Update needed values of w and compute nodePot */
        for(all_n) { 
            for(all_state)
                nodePot(n,state) = 0;
            for(all_features) {
                feature = X[sentences[s]-1 + n + nWords*f];
                if(feature != 0) {
                    featureInd = featureStart[f]-1 + feature-1;
                    for(all_state) {
                        ind = featureInd + nFeaturesTotal*state;
                        if (iter > 0) {
                            if (lastVisited[ind]==0)
                                w[ind] -= d[ind]*cumSum[iter-1];
                            else if (lastVisited[ind] != iter)
                                w[ind] -= d[ind]*(cumSum[iter-1]-cumSum[lastVisited[ind]-1]);
                            lastVisited[ind] = iter;
                        }
                        nodePot(n,state) += w[ind];
                    }
                }
            }
        }
        /* Add beginning/end of sentence modification */
        for(all_state) { 
            nodePot(0,state) += v_start[state];
            nodePot(nNodes-1,state) += v_end[state];
        }   
        /* Exponentiate Potentials */
        for(all_n) { 
            for(all_state) {
                nodePot(n,state) = exp(rho*nodePot(n,state));
            }
        }
        /* Edge potentials */
        for(all_state2) {
            for(all_state1) {
                edgePot(state1,state2) = exp(rho*v(state1,state2));
            }
        }
               
        
        /* Forward-Backward to Compute Marginals */
        for(all_n)
            kappa[n] = 0;
        for(all_state) {
            alpha(0,state) = nodePot(0,state);
            kappa[0] += alpha(0,state);
        }
        for(all_state)
            alpha(0,state) /= kappa[0];
        /* Forward Pass */
        for(n = 1; n < nNodes; n++) {
            for(all_state1) {
                for(all_state2)
                    tmp(state1,state2) = alpha(n-1,state1) * edgePot(state1,state2);
            }
            for(all_state2) {
                alpha(n,state2) = 0;
                for(all_state1)
                    alpha(n,state2) += tmp(state1,state2);
                alpha(n,state2) = nodePot(n,state2) * alpha(n,state2);
                kappa[n] += alpha(n,state2);
            }
            for(all_state)
                alpha(n,state) /= kappa[n];
        }
        /* Backward Pass */
       for(all_state)
            beta(nNodes-1,state) = 1;
        for(n = nNodes-2; n >= 0; n--) {
            for(all_state1) {
                for(all_state2)
                    tmp(state1,state2) = nodePot(n+1,state2)*edgePot(state1,state2)*beta(n+1,state2);
            }
            Z = 0;
            for(all_state1) {
                beta(n,state1) = 0;
                for(all_state2)
                    beta(n,state1) += tmp(state1,state2);
                Z += beta(n,state1);
            }
            for(all_state)
                beta(n,state) /= Z;
        }
        
        /* Compute beliefs for use in gradient update */
        /* Node Beliefs */
        for(all_n) {
            Z = 0;
            for(all_state) {
                nodeBel(n,state) = alpha(n,state)*beta(n,state);
                Z += nodeBel(n,state);
            }
            for(all_state)
                nodeBel(n,state) /= Z;
        }         
        /* Edge Beliefs */
        for(n = 0; n < nNodes-1; n++) {
            Z = 0;
            for(all_state1) {
                for(all_state2) {
                    tmp(state1,state2) = alpha(n,state1)*nodePot(n+1,state2)*beta(n+1,state2)*edgePot(state1,state2);
                    Z += tmp(state1,state2);
                }
            }
            for(all_state1) {
                for(all_state2) {
                    edgeBel(state1,state2,n) = tmp(state1,state2)/Z;
                }
            }
        }
                   
        /* Update directions and number of examples we've seen*/
        if(!covered[s]) {
            covered[s]=1;
            nCovered++;
            /* Component of direction from observed data */
            for(all_n) {
                for(all_features) {
                    feature = X[sentences[s]-1 + n + nWords*f];
                    if(feature != 0) {
                        featureInd = featureStart[f]-1 + feature-1;
                        state = y[sentences[s]-1 +n]-1;
                        dW[featureInd + nFeaturesTotal*state] -= 1;
                    }
                }
            }
            dV_start[y[sentences[s]-1]-1] -= 1;
            dV_end[y[sentences[s]-1 + nNodes-1]-1] -= 1;
            for(n = 0; n < nNodes-1; n++) {
                state1 = y[sentences[s]-1 +n]-1;
                state2 = y[sentences[s]-1 +n+1]-1;
                dV(state1,state2) -= 1;
            }
        }
        /* Component of direction from expectations and store beliefs */
        for(all_n) {
            for(all_features) {
                feature = X[sentences[s]-1 + n + nWords*f];
                if(feature != 0) {
                    featureInd = featureStart[f]-1 + feature-1;
                    for(all_state) {
                        dW[featureInd + nFeaturesTotal*state] -= NB(sentences[s]-1+n,state) - nodeBel(n,state);
                    }
                }
            }
        }
        for(all_state) {
            dV_start[state] -= NB(sentences[s]-1,state) - nodeBel(0,state);
            dV_end[state] -= NB(sentences[s]-1+nNodes-1,state) - nodeBel(nNodes-1,state);
        }
        for(all_n) {
            for(all_state) {
                NB(sentences[s]-1+n,state) = nodeBel(n,state);
            }
        }
        for(all_state1) {
            for(all_state2) {
                dV(state1,state2) -= EB(state1,state2,s);
            }
        }
        for(all_state1) {
            for(all_state2) {
                EB(state1,state2,s) = 0;
            }
        }
        for(n = 0; n < nNodes-1; n++)
        {
            for(all_state1) {
                for(all_state2) {
                    EB(state1,state2,s) += edgeBel(state1,state2,n);
                }
            }
        }
        for(all_state1) {
            for(all_state2) {
                dV(state1,state2) += EB(state1,state2,s);
            }
        }
        
                
        /* Update Parameters */
        /* For lazy updates of node parameters */
        rho *= 1-stepSize*lambda;
        if (iter == 0)
            cumSum[0] = stepSize/(rho*nCovered);
        else
            cumSum[iter] = cumSum[iter-1] + stepSize/(rho*nCovered);
        
        /* Update edge parameters explicitly */
        step = stepSize/(rho*nCovered);
        for(all_state) {
            v_start[state] -= step*dV_start[state];
            v_end[state] -= step*dV_end[state];
        }
        for(all_state1) {
            for(all_state2) {
                v(state1,state2) -= step*dV(state1,state2);
            }
        }
        
    }
    
    /* Get final values of w */
    for(f = 0; f < nFeaturesTotal*nStates; f++) {
            if (lastVisited[f]==0)
                w[f] -= d[f]*cumSum[maxIter-1];
            else
                w[f] -= d[f]*(cumSum[maxIter-1]-cumSum[lastVisited[f]-1]);
    }
    
    /* Scale variables to get final result */
    for(f = 0; f < nParams; f++)
        wv[f] = wv[f]*rho;
    
    
    mxFree(nodePot);
    mxFree(edgePot);
    mxFree(alpha);
    mxFree(beta);
    mxFree(tmp);
    mxFree(nodeBel);
    mxFree(edgeBel);
    mxFree(kappa);
    mxFree(lastVisited);
    mxFree(cumSum);
}