package cve;
import java.io.*;
import ve.*;

public class Testercve {
    public static void main(String[] args) {
	ContextualBeliefNetwork bn = 
	    new ContextualBeliefNetworkFromText(readFile("examples/fig4.cve"),100);
//  	BeliefNetwork bnet = new BeliefNetwork(readFile("fig4.bn"),100);
//  	ContextualBeliefNetwork bn = new ContextualBeliefNetwork(bnet);
	bn.print();

//  	System.out.println("Eliminating D:");
//  	(bn.getRules().eliminate(bn.getVariables()[5])).print();
	Variable[] queryVars = {(Variable) bn.getStringToVar().get("D")};
	Variable[] observedVars = {(Variable) bn.getStringToVar().get("E")};
	int[] observedVals = {1};
	String[] eo = {"Y", "Z","A","B","C"};
	long prequeryTime = System.currentTimeMillis();
	CVEQuery ans =new CVEQuery(queryVars,bn,observedVars,observedVals,eo);
	long postqueryTime = System.currentTimeMillis();
	System.out.println("\n***Result P(D | E=false)");
	ans.getResult().print();
	System.out.println("Time: "+(postqueryTime-prequeryTime)+" msecs.");
    }

    private static String readFile(String fileName) {
	try {
	    BufferedReader in =  new BufferedReader( new FileReader( fileName ) );
	    String line;
	    String all = "";

	    line = in.readLine();
	    while( line != null ) {
		    all += line + "\n";
		    line = in.readLine();
		}
	    in.close();
	    return all;
	}
	catch( Exception e ) {
	    System.out.println( "Error: " + e.toString() );
	    return "";
	}
    }
}
