package cve;
import ve.*;

/**
 * This is a rule collection that we make by adding factors. It is
 * only a new class because I wanted it in another file ;^}
 *
 * @author David Poole
 * @version 0.1 2001-04-10
 **/

public class RuleCollectionFromBeliefNetwork extends RuleCollection {

    /**
     * construces a rule collection from a belief network.
     **/
    RuleCollectionFromBeliefNetwork(BeliefNetwork bn) {
	super();
	int preSize=0;
	int postSize=0;
	for (int i=0; i< bn.getNumVariables(); i++) {
	    Variable[] factorFor = {bn.getVariables()[i]};
	    System.out.print("\nConverting factor on [");
	    bn.getProbFactors()[i].printVariables();
	    System.out.println("]. For: " +bn.getVariables()[i].getName()+". Size:"+bn.getProbFactors()[i].size()+".");
	    preSize+=bn.getProbFactors()[i].size();
	    int newSize=addFactor(new Context(),bn.getProbFactors()[i],factorFor);
	    System.out.println("Resulting size: "+bn.getProbFactors()[i].size()+" -> "+newSize);
	    postSize += newSize;
	}
	System.out.println("\n\nConversion Complete. Size reduced to "+postSize+" from "+preSize+".");
    }

    private int addFactor(Context con,Factor fac,Variable[] ruleIsFor) {
//  	System.out.println("\n*** addFactor");
//  	con.print();
//          System.out.println(":");	
//  	fac.print("  | ");

	Variable currentBest = null;
	int resultingSize=fac.size();
	int numVars = fac.getVariables().length;
	Variable[][] redundantVarsForEachValue = null; //stupid initialization needed
	int[] numRedundantVarsForEachValue = null;// stupid initialization needed
	for (int varp=0; varp < numVars; varp++) {
	    // check whether this variable is the appropriate one to split.
	    Variable[][] newRedundantVarsForEachValue = new Variable[fac.getVariables()[varp].getDomain().length][];
	    int[] newNumRedundantVarsForEachValue = new int[fac.getVariables()[varp].getDomain().length];
	    int newSize=0;
	    for (int val=0; val < fac.getVariables()[varp].getDomain().length; val++) {
		// for each value we check how much the factor size
		// can be reduced for this value
		newRedundantVarsForEachValue[val]=new Variable[numVars];
		newNumRedundantVarsForEachValue[val]=0;
		int valSize=1;
		Factor fnew=new FactorAssign(fac,fac.getVariables()[varp],val);
//  		System.out.println("\n\nRedundancy Test. Factor:");
//  		fnew.print();
		for (int i=0; i < numVars; i++) {
		    if (i != varp) {
			if (fac.getVariables()[i] != ruleIsFor[0] &&
			    fnew.isRedundant(fac.getVariables()[i])) {
//  			    System.out.println("   Variable "+fac.getVariables()[i].getName()+" is redundant");
			    newRedundantVarsForEachValue[val][newNumRedundantVarsForEachValue[val]++]=fac.getVariables()[i];
			}
			else {
			    valSize *= fac.getVariables()[i].getDomain().length;
			}
		    }
		}
		newSize+=valSize;
	    }
	    if (newSize < resultingSize) {
		currentBest=fac.getVariables()[varp];
		resultingSize = newSize;
		redundantVarsForEachValue=newRedundantVarsForEachValue;
		numRedundantVarsForEachValue=newNumRedundantVarsForEachValue;
	    }
	}
	if (currentBest==null) {
	    // no variable is suitable to split on
	    GenRule newRule = new GenRule(con,fac,ruleIsFor);
  	    System.out.print("New rule added: ");
  	    newRule.printBrief();
	    this.add(newRule);
	    return newRule.getFactor().size();
	}
	else {
	    // we want to split on currentBest
//  	    System.out.print("\nSplitting Factor on "+currentBest.getName()+": [");
//  	    fac.printVariables();
//  	    System.out.print("] in context:");
//  	    con.print();
	    int resSize=0;
	    for (int val=0; val<currentBest.getDomain().length;val++) {
		resSize += 
		    addFactor(new Context(con,currentBest,val),
			  factorProject(fac,currentBest,val,redundantVarsForEachValue[val],
					numRedundantVarsForEachValue[val]),
			  ruleIsFor);
	    }
	    return resSize;
	}
    }

    private Factor factorProject(Factor fac, 
				 Variable var, 
				 int val, 
				 Variable[] redundantVars, 
				 int numRedundantVars) {
//  	System.out.print(" on "+var.getName()+"="+val+". Redundant:");
//  	for (int i=0; i< numRedundantVars; i++) {
//  	    System.out.print(" "+redundantVars[i].getName());
//  	}
//  	System.out.println(".");
	Variable[] newReds = new Variable[numRedundantVars+1];
	int[] vals = new int[numRedundantVars+1];
	int i=0;
	while (i< numRedundantVars && redundantVars[i].getId() < var.getId()) {
	    newReds[i]=redundantVars[i];
	    vals[i]=0;;
	    i++;
	}
	newReds[i]=var;
	vals[i]=val;
	while (i< numRedundantVars) {
	    newReds[i+1]=redundantVars[i];
	    i++;
	}	
	return new FactorObserved(fac,newReds,vals);
    }

}
