package cve;
import ve.*;

/**
 * This the the class of factors that have random values.
 *
 * @author David Poole
 * @version 0.1 2001-05-12
 **/
public class FactorRandom extends FactorStored {

    /**
     * constructs a factor with the given variables.
     *
     * @param vars the list of variables
     * @param initProbs the initial Probability for each node
     **/
    public FactorRandom(Variable[] vars) {
	super(vars,BY_UPDATABLE);
	for (int i=0; i<this.size(); i++) {
	    factorValues[i]=Math.random();
	}
    }

    public FactorRandom(Variable[] vars, int length) {
	super(prune(vars,length),BY_UPDATABLE);
	for (int i=0; i<this.size(); i++) {
	    factorValues[i]=Math.random();
	}
    }

    private static Variable[] prune(Variable[] vars, int length) {
	if (vars.length==length) {
	    return vars;
	}
	else {
	    Variable[] result = new Variable[length];
	    for (int i=0; i<length; i++) {
		result[i]=vars[i];
	    }
	    return result;
	}
    }

    /**
     * updates every stored value corresponding to the rule. This must
     * also update all of the values.
     *
     * @param pos the position in the array to be updated
     * @param val the new value
     **/
    public void update(int pos, double val) {
	factorValues[pos]=val;
    }

}
