package cve;
import java.io.*;
import ve.*;

/**
 * a factor that is the result of a query.
 *
 * @author David Poole
 * @version 0.2 2001-04-04 */
public class CVEQuery {



    /**
     * constructs the factor that answers the specific query for a
     * given elimination ordering.
     *
     * @param queryVars the array of variables being queried. These
     * are assumed to be in order and must be a subset of the
     * variables in bnet.  
     * @param bnet a belief network.
     * @param observedVars the array of variables that have observed
     * values. These are assumed to be in order and must be a subset
     * of the variables in bnet.  
     * @param ObservedVals the array of values for the corresponding
     * observed values. Each value ObservedVals[i] is the index into
     * ObservedVars[i].domain. 
     * @param ElimOrd the string of variables that specifies the elimination ordering. We assume this is correct.
     **/
    CVEQuery(Variable[] queryVars, ContextualBeliefNetwork bnet, 
	  Variable[] observedVars, int[] observedVals, String[] eo) {
	RuleCollection obsRules = bnet.getRules().observe(observedVars,observedVals);
	for (int i=0; i< eo.length; i++) {
//  	    obsRules.print();
	    Variable elimVar = (Variable) bnet.getStringToVar().get(eo[i]);
	    System.out.println("Eliminating "+elimVar.getName());
	    obsRules=obsRules.eliminate(elimVar);
	}
	result = obsRules;
    }

    private RuleCollection result;

    /** 
     * gets the result of the query.  */
    RuleCollection getResult() {
	return result;
    }
}
