package cve;
import java.util.*;
import ve.*;

/**
 * A ContextualBeliefNetwork contains a tuple of {@link Variable}s
 * (each with a domain) and a set of generalised rules (of the form
 * {@link GenRule}).

 * @author David Poole
 * @version 0.1 2001-05-22
 **/
public class ContextualBeliefNetwork {

    protected RuleCollection rules;
    protected Variable[] variables;
    protected int numVariables;
    protected final static int maxDomainSize=100;
    protected final static int maxFactorSize=30;
    protected final static int maxContextSize=30;

    public RuleCollection getRules() {
	return rules;
    }
    public Variable[] getVariables() {
	return variables;
    }
    public int getNumVariables() {
	return numVariables;
    }

    /** maps the string name to the variable. */
    protected Hashtable stringToVar;

    /** returns the map from the string name to the variable. */
    public Hashtable getStringToVar() {
	return stringToVar;
    }

    /**
     * dummy constructor. Does nothing.
     **/
    ContextualBeliefNetwork() {
    }

    /**
     * constructs a contextual belief network from a beleif network.
     **/
    ContextualBeliefNetwork(BeliefNetwork bn) {
	rules = new RuleCollectionFromBeliefNetwork(bn);
	variables = bn.getVariables();
	numVariables = bn.getNumVariables();
	stringToVar = bn.getStringToVar();
    }
    
    /**
     * add a new rule to the contextual belief network
     **/
    public void add(GenRule rule) {
	rules.add(rule);
    }

    /**
     * prints the contextual belief network
     **/
    public void print() {
	rules.print();
    }

    /**
     * prints a summary of the contextual belief network
     **/
    public void printBrief() {
	rules.printBrief();
    }

}


