package ve;
import java.io.*;

public class Testerpr {
    public static void main(String[] args) {
	DecisionNetwork bn = new DecisionNetworkFromCIspaceFormat(readFile("examples/fig4.dn"),100);
//  	for (int i=0; i<bn.getNumVariables(); i++) {
//  	    System.out.println("\n Factor #"+i+":");
//  	    bn.getProbFactors()[i].print();
//  	}

	System.out.println("\nP(B|E=true)");
	Variable[] observed = {bn.getVariables()[6]};
	int[] vals = {0};
  	Variable[] queried = {bn.getVariables()[5]};
	long prequeryTime = System.currentTimeMillis();
	Query qry = new Query(queried,bn,observed,vals,"random");
  	Factor res=qry.getUnNormResult();
	long postqueryTime = System.currentTimeMillis();

  	System.out.println("Result:");
  	res.print();
	System.out.println("Time: "+(postqueryTime-prequeryTime)+" msecs.");

	Variable[] eo=qry.getEO();
	System.out.println("Elimination ordering:");
	for (int i=0; i<eo.length; i++) {
	    System.out.print(" "+eo[i].getName());
	}

    }

    private static boolean factorEq(Factor f1,Factor f2) {
	EltsIterator I1 = f1.iterator();
	EltsIterator I2 = f2.iterator();
	while (I1.hasNext() && I2.hasNext()) {
	    if (I1.next() != I2.next()) {
		return false;}
	}
	return I1.hasNext()==I2.hasNext();
    }

    private static String readFile(String fileName) {
	try {
	    BufferedReader in =  new BufferedReader( new FileReader( fileName ) );
	    String line;
	    String all = "";

	    line = in.readLine();
	    while( line != null )
		{
		    all += line + "\n";
		    line = in.readLine();
		}
	    in.close();
	    return all;
	}
	catch( Exception e ) {
	    System.out.println( "Error: " + e.toString() );
	    return "";
	}
    }
}
