package ve;

import java.io.*;

public class Tester {
    public static void main(String[] args) {
	DecisionNetwork bn = new DecisionNetworkFromCIspaceFormat(readFile("examples/firealarm20.dn"),100);
	// sum out tampering
	Variable[] ta = {bn.getVariables()[0]};
	Factor first =
	    new FactorSumOut(new FactorTimes(bn.getProbFactors()[0],bn.getProbFactors()[2]),ta);
	first.print();
	// sum out fire
	Variable[] fi = {bn.getVariables()[1]};
	Factor second =
	    new FactorSumOut(new FactorTimes(
					     new FactorTimes(bn.getProbFactors()[1],bn.getProbFactors()[7]),
					     new FactorTimes(bn.getProbFactors()[3],first)),fi);
	second.print();
	// sum out alarm
	Variable[] al = {bn.getVariables()[2]};
	Factor third =
	    new FactorSumOut(new FactorTimes(bn.getProbFactors()[4],second),al);

	third.print();
	// sum out leaving
	Variable[] le = {bn.getVariables()[4]};
	Factor fourth =
	    new FactorSumOut(new FactorTimes(bn.getProbFactors()[5],third),le);

	fourth.print();
	// sum out smoke
	Variable[] sm = {bn.getVariables()[3]};
	//bn.getProbFactors()[6].print();
	Factor fifth =
	    new FactorSumOut(new FactorTimes(bn.getProbFactors()[6],fourth),sm);

	fifth.print();

	// optimize call
	FactorMax sixth= new FactorMax(fifth,bn.getVariables()[8]);
	sixth.print();

	System.out.println("\n Policy Function");
	sixth.getPolicyFunction().printPolicyFunction();
	sixth.getPolicyFunction().print();

	// sum out seesmoke
	Variable[] ss = {bn.getVariables()[7]};
	Factor seventh = new FactorSumOut(sixth,ss);
	seventh.print();

	// optimize check
	FactorMax eighth= new FactorMax(seventh,bn.getVariables()[6]);
	eighth.print();

	System.out.println("\nPolicy Function");
	eighth.getPolicyFunction().printPolicyFunction();
	eighth.getPolicyFunction().print();
	// sumout report
	Variable[] re = {bn.getVariables()[5]};
	Factor ninth = new FactorSumOut(eighth,re);
	ninth.print();

    }

    private static boolean factorEq(Factor f1,Factor f2) {
	EltsIterator I1 = f1.iterator();
	EltsIterator I2 = f2.iterator();
	while (I1.hasNext() && I2.hasNext()) {
	    if (I1.next() != I2.next()) {
		return false;}
	}
	return I1.hasNext()==I2.hasNext();
    }

    private static String readFile(String fileName) {
	try {
	    BufferedReader in =  new BufferedReader( new FileReader( fileName ) );
	    String line;
	    String all = "";

	    line = in.readLine();
	    while( line != null )
		{
		    all += line + "\n";
		    line = in.readLine();
		}
	    in.close();
	    return all;
	}
	catch( Exception e ) {
	    System.out.println( "Error: " + e.toString() );
	    return "";
	}
    }
}
