package ve;

/**
 * This is a factor that has a uniform probability. This is here
 * because it is the initial factor before anything is changed.
 * @author David Poole
 * @version 0.1 2001-05-22
 **/
public class FactorUniform extends Factor {

    /**
     * constructs a factor with the given variables.
     *
     * @param vars the list of variables
     * @param val the value that each element takes
     */
    public FactorUniform(Variable[] vars, double val) {
	super(vars,BY_UNIFORM);
	uniformVal=val;
    }

    private double uniformVal;


    // Iterators

    /*
     * Returns an iterator over the values of the factor. This code is
     * based on the Iterator code in java.util.AbstractList.
     */
    public EltsIterator iterator() {
	return new Itr();
    }

    private class Itr implements EltsIterator {
	/** 
	 * Index of element to be returned by subsequent call to next.
	 */
	int curpos = 0;

	public boolean hasNext() {
	    return curpos != size();
	}

	public double next() {
	    curpos++;
	    return uniformVal;
	}
	
	public int currPos() {
	    return curpos;
	}

	public void backTo(int pos) {
	    curpos = pos;
	}
    }
}
