package ve;

/**
 * This the the class of factors that are created by summing out a set
 * of variables from another factor.
 *
 * Copyright 2001, David Poole. All rights reserved.
 *
 * @author David Poole
 * @version 0.1 2001-01-26
 **/
public class FactorSumOutPretend extends FactorStoredPretend {

    /**
     * constructs a factor with the given variables.
     *
     * @param f1 the original factor. 
     * @param vars the list of variables to be summed out. This
     * assumes that vars is a subset of f1.getVariables().  
     **/
    public FactorSumOutPretend(Factor f1, Variable[] vars) {
	super(setDiff(f1.getVariables(),vars),BY_SUM_OUT);
	if (getSavingForTracing()) {
	    theFactor = f1;
	    theVariables = vars;
	}
    }

    /**
     * returns the array representing the set difference of the variables.
     *
     * @param vars1 an ordered list of variables.
     * @param vars2 an ordered list of variables.
     * @return the elements of vars1 not in vars2.
     */
    public static Variable[] setDiff(Variable[] vars1, Variable[] vars2) {
	Variable[] vars = new Variable[vars1.length];
	int pos=0;  // number of elements currently in the difference
	int i1=0;   // next position in vars1
	int i2=0;   // next position in vars2
	while (i1<vars1.length && i2<vars2.length) {
	    if (vars1[i1]==vars2[i2]) {
		i1++; i2++;}
	    else if (vars1[i1].getId() < vars2[i2].getId()) {
		vars[pos++]=vars1[i1++]; }
	    else { 
                i2++; }
	}
	while (i1<vars1.length) {
	    vars[pos++]=vars1[i1++];}
        Variable[] result = new Variable[pos];
	for (int i=0; i<pos; i++) {
	    result[i]=vars[i];
	}
	return result;
    }


    /**
     * the factor that the variable is being summed out from
     **/
    private Factor theFactor;

    /**
     * returns the factor that the variable is being summed out from
     **/
    public Factor getTheFactor() {
	return theFactor;
    }
    /**
     * the variables being summed out
     **/
    private Variable[] theVariables;
    /**
     * returns the variables being summed out
     **/
    public Variable[] getTheVariables() {
	return theVariables;
    }

}
