package ve;

/**
 * This the the class of stored factors, but we only pretend to store
 * them. This is useful for, for example, finding the elimination
 * oredering an algorithm would have used.

 * @author David Poole
 * @version 0.1 2001-06-08
 **/
public class FactorStoredPretend extends Factor {

    /**
     * constructs a factor with the given variables.
     *
     * @param vars the list of variables
     * @param how an integer representing how the factor was created
     */
    public FactorStoredPretend(Variable[] vars, int how){
	super(vars,how);
	size=this.size();
    }

    int size;
    // Iterators

    /*
     * Returns an iterator over the values of the factor. This code is
     * based on the Iterator code in java.util.AbstractList.
     */
    public EltsIterator iterator() {
	return new Itr();
    }

    private class Itr implements EltsIterator {
	/** 
	 * Index of element to be returned by subsequent call to next.
	 */
	int curpos = 0;

	public boolean hasNext() {
	    return curpos != size;
	}

	public double next() {
	    curpos++;
	    return 0.0;
	}
	
	public int currPos() {
	    return curpos;
	}

	public void backTo(int pos) {
	    curpos = pos;
	}
    }
}
