package ve;

/**
 * This the the class of stored factors. It contains the array to
 * store the data and an {@link EltsIterator EltsIterator} to enable
 * one to enumerate the elements of the array.

 * @author David Poole
 * @version 0.1 2001-01-11 
 **/
public class FactorStored extends Factor {

    /**
     * constructs a factor with the given variables.
     *
     * @param vars the list of variables
     * @param how an integer representing how the factor was created
     */
    public FactorStored(Variable[] vars, int how){
	super(vars,how);
	factorValues= new double[this.size()];
    }

    /**
     * is the array of stored values.
     */
    protected double[] factorValues;

    // Iterators

    /*
     * Returns an iterator over the values of the factor. This code is
     * based on the Iterator code in java.util.AbstractList.
     */
    public EltsIterator iterator() {
	return new Itr();
    }

    private class Itr implements EltsIterator {
	/** 
	 * Index of element to be returned by subsequent call to next.
	 */
	int curpos = 0;

	public boolean hasNext() {
	    return curpos < factorValues.length;
	}

	public double next() {
	    return factorValues[curpos++];
	}
	
	public int currPos() {
	    return curpos;
	}

	public void backTo(int pos) {
	    curpos = pos;
	}
    }
}
