package ve;
import java.util.*;

/**
 * a place to store factors during computation using a given
 * elimination ordering
  *
 * @author David Poole
 * @version 0.1 2001-06-08
 **/


public class FactorStoreSequential extends FactorStore {
    private Variable[] theVariables;
    private int varPos;
    private int factorMaxSize;
    private Variable last;
    private Factor[][] buckets;
    private int[] bucketSize;
    private Hashtable varToBucketIndex;
    private Factor[] finalFactors;
    private int numFinalFactors;

    /** generate a factor store containing the given initial factors and initial variables.
     **/
    public FactorStoreSequential(Variable[] toSumOut,Factor[] initialFactors, int numInitFactors) {
	theVariables=toSumOut;
	varPos=0;
	factorMaxSize=(numInitFactors<10 ? numInitFactors : 10);
	buckets = new Factor[toSumOut.length][factorMaxSize];
	bucketSize=new int[toSumOut.length];
	varToBucketIndex = new Hashtable(toSumOut.length*3/2);
	finalFactors = new Factor[numInitFactors];
	for (int i=0; i< toSumOut.length; i++) {
	    varToBucketIndex.put(toSumOut[i],new Integer(i));
	}
	for (int i=0; i<numInitFactors; i++) {
	    addtoBuckets(initialFactors[i]);
	}
    }

    public boolean hasNext() {
	return varPos<theVariables.length;
    }

    public Variable next() {
	return theVariables[varPos];
    }
    
    public void addFactor(Factor newFactor) {
	varPos++;
	addtoBuckets(newFactor);
    }

    public void dontAddFactor() {
	varPos++;
    }

    /**
     * adds a factor to the appropriate bucket
     **/
    private void addtoBuckets(Factor fac) {
	int lowestBucket = Integer.MAX_VALUE;
	for (int i=0; i<fac.getVariables().length; i++) {
	    Integer pos = (Integer) varToBucketIndex.get(fac.getVariables()[i]);
	    if (pos != null
		&& pos.intValue() >= varPos 
		&& pos.intValue() < lowestBucket) {
		lowestBucket = pos.intValue();
	    }
	}
	if (lowestBucket == Integer.MAX_VALUE) {
	    finalFactors[numFinalFactors++]=fac;
	}
	else {
	    // we should expand the bucket if it fills up
	    if (buckets[lowestBucket].length == bucketSize[lowestBucket]) {
		// bucket is full. Enlarge it before adding anything.
		Factor[] newBucket = new Factor[1+buckets[lowestBucket].length*2];
		for (int i=0; i<buckets[lowestBucket].length; i++) {
		    newBucket[i]=buckets[lowestBucket][i];
		}
		buckets[lowestBucket]=newBucket;
	    }
	    buckets[lowestBucket][bucketSize[lowestBucket]++]=fac;
	}
    }

    /**
     * Returns an iterator over the factors that contain the variable
     * var. 
     **/
    public FactorIterator emunFactorsRemoved() {
	 return new FacItr(buckets[varPos],bucketSize[varPos]);
    }

    /**
     * Returns an iterator over the the remaining factors.
     **/
    public FactorIterator emunFactorsRemaining() {
	return new FacItr(finalFactors,numFinalFactors);
    }

    private class FacItr implements FactorIterator {
	int curpos=0;
	Factor[] toReturn;
	int numToReturn;

	FacItr(Factor[] toReturn, int numToReturn) {
	    this.toReturn = toReturn;
	    this.numToReturn = numToReturn;
	}

	/** 
	 * returns true if there are more elements. 
	 */
	public boolean hasNext() {
	    return curpos < numToReturn;
	}
	/** 
	 * returns the next element in the iterator.
	 */
	public Factor next() {
	    return toReturn[curpos++];
	}
	
    }
}
