package ve;

/**
 * a place to store factors during computation. This is a naive
 * implementation. A better implementation would do better indexing.
  *
 * @author David Poole
 * @version 0.1 2001-04-04
 **/


public class FactorStoreRandom extends FactorStore {
    private Factor[] theFactors;
    private int numFactors;
    private Variable[] theVariables;
    private int numVariables;
    private int factorMaxSize;
    private Variable last;


    /** generate a factor store containing the given initial factors and initial variables.
     **/
    public FactorStoreRandom(Variable[] toSumOut,Factor[] initialFactors, int numInitFactors) {
	theFactors=initialFactors;
	this.numFactors=numInitFactors;
	theVariables=toSumOut;
	this.numVariables=toSumOut.length;
	factorMaxSize=numInitFactors;
    }

    public boolean hasNext() {
	return numVariables>0;
    }

    public Variable next() {
	int index = (int) (Math.random() * numVariables);
	last=theVariables[index];
	theVariables[index]=theVariables[--numVariables];
	return last;
    }
    
    public void addFactor(Factor newFactor) {
	if (numFactors == factorMaxSize) {  //double the store
	    factorMaxSize *= 2;
	    Factor[] newFactors = new Factor[factorMaxSize];
	    for (int i=0; i< numFactors; i++) {
		newFactors[i]=theFactors[i];
	    }
	    theFactors=newFactors;
	}
	theFactors[numFactors++]=newFactor;
    }

    public void dontAddFactor() {
	numFactors++;
    }

    /**
     * Returns an iterator over the factors that contain the variable
     * var. Note that we remove the factors as we access them. We
     * should really index properly so that this can be done in time
     * proportional to the number of factors that contain the
     * variable, not linear in the total number of factors.
     **/
    public FactorIterator emunFactorsRemoved() {
	Factor[] toReturn = new Factor[numFactors];
	int posToReturn=0;
	int newfacpos=0;
	for (int pos=0; pos<numFactors; pos++) {
	    if (theFactors[pos].contains(last)) {
		toReturn[posToReturn++]=theFactors[pos];
	    }
	    else {
		theFactors[newfacpos++]=theFactors[pos];
	    }
	}
	numFactors=newfacpos;
	return new FacItr(toReturn,posToReturn);
    }

    /**
     * Returns an iterator over the the remaining factors.
     **/
    public FactorIterator emunFactorsRemaining() {
	return new FacItr(theFactors,numFactors);
    }

    private class FacItr implements FactorIterator {
	int curpos=0;
	Factor[] toReturn;
	int numToReturn;

	FacItr(Factor[] toReturn, int numToReturn) {
	    this.toReturn = toReturn;
	    this.numToReturn = numToReturn;
	}

	/** 
	 * returns true if there are more elements. 
	 */
	public boolean hasNext() {
	    return curpos < numToReturn;
	}
	/** 
	 * returns the next element in the iterator.
	 */
	public Factor next() {
	    return toReturn[curpos++];
	}
	
    }
}
