package ve;
import java.util.*;
/**
 * a place to store factors during computation. This indexes to find
 * the the minimal deficiency variable or the min-size variable
 * efficiently.
 *
 * @author David Poole
 * @version 0.1 2001-05-30
 **/
public class FactorStoreIndexed extends FactorStore {
    private VariableToEliminate[] varsPQ;
    //private VariableToEliminate qVar;
    private int numVariables;   // number of variables to be elimianted
    private VariableToEliminate last=null;
    //private Factor[] factorHistory;
    Hashtable varToVarInQuery;
    private Factor[] finalFacs;
    private int numFinalFacs;

    public FactorStoreIndexed(Variable[] toSumOut,
			      Factor[] initFactors, 
			      int numInitFactors) {
//  	System.out.println("In FactorStoreIndexed.");
	varToVarInQuery = new Hashtable(toSumOut.length*3/2);
	varsPQ = new VariableToEliminate[toSumOut.length];
	finalFacs = new Factor[initFactors.length+1];
	numFinalFacs =0;
	for (int i=0; i<toSumOut.length;i++) {
	    varsPQ[i]=new VariableToEliminate(toSumOut[i],toSumOut.length);
	}
	
	for (int i=0; i< numInitFactors ; i++) {
	    //addFactor(initFactors[i]);
	    new FactorLink(initFactors[i]);
	}
	numVariables = toSumOut.length;
//  	computeDeficiency();
	if (toSumOut.length>0) {
	    for (int i=1; i<toSumOut.length;i++) {
		shuffleUp(i);
	    }
	}
    }


    /** is true if there is a next variable to eliminate.
     **/
    public boolean hasNext() {
	return numVariables>0;
    }

    /** returns the next variable to eliminate according to the
     * current heuristic.
     **/
    public Variable next() {
//  	System.out.println("\n"+varsPQ[0].var.getName()+" is at the top of the heap");
//  	System.out.println(" num factors:"+varsPQ[0].numFactors+". numNeighbours:"+varsPQ[0].numNeighbours);
	last = varsPQ[0];
	varsPQ[0] = varsPQ[--numVariables];
	shuffleDown(0);
	return last.var;
    }

    /**
     finish up but don't add any factors.  I don't know if this works. It hasn't been debugged. 
    **/
    public void dontAddFactor() {
    }

    /**
     * adds the factor to the factor store. Note that this is only
     * used for computed factors.
     **/
    public void addFactor(Factor fac) {
	cleanUp(fac);
	FactorLink fl = new FactorLink(fac);
//  	recomputeDeficiency(f1);
    }

    private void cleanUp(Factor fac) {
	for (int i=0; i<fac.getVariables().length; i++) {
	    VariableToEliminate vte = (VariableToEliminate) varToVarInQuery.get(fac.getVariables()[i]);
	    if (vte != null) {
		vte.computeNeighbours();
	    }
	}
    }

    /**
     * returns an enumerator over the variables for the last variable
     * returned.
     **/
    public FactorIterator emunFactorsRemoved() {
	return new EnumFacsRem();
    }
    
    private class EnumFacsRem implements FactorIterator {
	FactorLink nextFact = last.factors;
	public boolean hasNext() {
	    return nextFact != null;
	}
	public Factor next() {
	    Factor res=nextFact.fac;
	    int i=0;
	    while (//i<nextFact.numVarsToElim && 
		   nextFact.vars[i] != last) {
		i++;
	    }
//  	    if (i<nextFact.numVarsToElim) {
		FactorLink newNextFact = nextFact.next[i];
		nextFact.remove();
		nextFact=newNextFact;
//  	    }
//  	    else {
//  		// this should probably raise an exception
//  		System.out.println("Warning: couldn't find "+last.var.getName()+" in "+res.getName()+".");
//  		System.out.println("  i="+i+". nextFact.numVarsToElim="+nextFact.numVarsToElim);
//  		nextFact = null;
//  	    }
	    return res;
	}
	    
    }

    /**
     * returns an enumerator over the variables for the last variable
     * returned.
     **/
    public FactorIterator emunFactorsRemaining() {
	return new EnumFacsRemaining();
    }
    
    private class EnumFacsRemaining implements FactorIterator {
	int pos=0;
	public boolean hasNext() {
	    return pos<numFinalFacs;
	}
	public Factor next() {
	    return finalFacs[pos++];
	}
    }

    /** make into a heap by shuffling down the value at position
     * pos. This assumes that varsPQ is a heap except maybe that the
     * value at position pos is larger than it's children.  
     **/
    private void shuffleDown(int pos) {
	int smallest;
	if (2*pos+1<numVariables 
	    && varsPQ[2*pos+1].valToMinimise()<varsPQ[pos].valToMinimise()) {
	    smallest=2*pos+1;
	}
	else {
	    smallest=pos;
	}
	if (2*pos+2<numVariables 
	    && varsPQ[2*pos+2].valToMinimise()<varsPQ[smallest].valToMinimise()) {
	    smallest=2*pos+2;
	}
	if (smallest != pos) {
	    // swap varsPQ[pos] & varsPQ[smallest]
	    VariableToEliminate tmp = varsPQ[pos];
	    varsPQ[pos]=varsPQ[smallest];
	    varsPQ[pos].positionInPQ=pos;
	    varsPQ[smallest]=tmp;
	    varsPQ[smallest].positionInPQ=smallest;
	    shuffleDown(smallest);
	}
    }

    /** make into a heap by shuffling up the value at position
     * pos. This assumes that varsPQ is a heap except maybe that the
     * value at position pos is smallerer than it's parent. 
     **/
    private void shuffleUp(int pos) {
	VariableToEliminate tmp = varsPQ[pos];
	while (pos>0 & tmp.valToMinimise()<varsPQ[(pos-1)/2].valToMinimise()) {
	    varsPQ[pos]=varsPQ[(pos-1)/2];
	    varsPQ[pos].positionInPQ=pos;
	    pos=(pos-1)/2;
	}
	varsPQ[pos]=tmp;
	varsPQ[pos].positionInPQ=pos;
    }

    /**
     * this class provides the infrastructure for the variable in the
     * priority queue.
     **/
    private class VariableToEliminate {
	/** the variable 
	 */
	Variable var;

	/** the Variables that are neighbours. In order. Note that
	 * this does not only include VariableToEliminates 
	**/
	 Variable[] neighbours; 

	/** the number of neighbours.  */
	int numNeighbours;

	/** the size of the resulting factor after this variable has
	 * been eliminated.
	 **/
	int size;

	void recomputeSize() {
	    size=1;
	    for (int i=0; i<numNeighbours; i++) {
		size *=neighbours[i].getDomain().length;
	    }
	}

	VariableToEliminate (Variable newvar,int maxNeighs) {
	    var=newvar;
	    varToVarInQuery.put(newvar,this);
	    neighbours= new Variable[maxNeighs];
	    numNeighbours=0;
	}

					    
//  	void addNeighbour(Variable var) {
//  	    int pos=0;
//  	    while (pos < numNeighbours && neighbours[pos].getId() < var.getId()) {
//  		pos++;
//  	    }
//  	    if (pos==numNeighbours  || neighbours[pos] != var) {
//  		// it is not already there
//  		for (int j=numNeighbours++; j>pos; j--) {
//  		    neighbours[j]=neighbours[j-1];
//  		}
//  		neighbours[pos]=var;
//  	    }
		
//  	}
	
	void computeNeighbours() {
	    // we could probably avoid this by making the neighbours
	    // include a count
	    numNeighbours=0;
	    FactorLink fL=factors;
	    while (fL != null) {
		addNeighbours(fL.fac.getVariables());
		int i=0;
		while (//i<fL.numVarsToElim && 
		       fL.vars[i] != this) {
		    i++;
		}
		fL=fL.next[i];
	    }
	    recomputeSize();
	}

	void addNeighbours(Variable[] vtes) {
	    Variable[] newNeighbours = new Variable[numNeighbours+ vtes.length];
	    int vpos=0;
	    int nbspos=0;
	    int newpos=0;
	    while (vpos < vtes.length && nbspos < numNeighbours) {
		if (vtes[vpos]==this.var) {
		    vpos++;
		}
		else if (vtes[vpos]==neighbours[nbspos]) {
		    newNeighbours[newpos++]=vtes[vpos++];
		    nbspos++;
		}
		else if (vtes[vpos].getId()<neighbours[nbspos].getId()) {
		    newNeighbours[newpos++]=vtes[vpos++];
		}
		else {
		    newNeighbours[newpos++]=neighbours[nbspos++];
		}
	    }
	    while (vpos < vtes.length) {
		newNeighbours[newpos++]=vtes[vpos++];
	    }
	    while (nbspos < numNeighbours) {
		newNeighbours[newpos++]=neighbours[nbspos++];
	    }
	    neighbours=newNeighbours;
	    numNeighbours=newpos;
	}
	    
	/** the index of the Factors that involve this variable. In no
	 * particular order.  */
	FactorLink factors;         

	/** the number of factors
	 **/
	int numFactors;

	/** the deficiency. */
	int deficiency;
	
	/** the index in the priority queue. */
  	int positionInPQ;

	/** returns the value to minimize (either the deficiency or the factor size).
	 **/
	int valToMinimise() {
	    return size;
	}
    }

    /** this is essentially, for each factor, a doubly linked list for
     * each variable in the factor.
     **/
    private class FactorLink {
	Factor fac;
	FactorLink[] prev;
	FactorLink[] next;
	VariableToEliminate[] vars;
	int numVarsToElim;
	
	FactorLink(Factor f1) {
	    fac=f1;
	    int numVars = f1.getVariables().length;
	    vars = new VariableToEliminate[numVars];
	    next = new FactorLink[numVars];
	    prev = new FactorLink[numVars];
	    numVarsToElim=0;
//  	    System.out.print("Incorporating factor "+f1.getName()+". Indexing to variables:");
	    for (int i=0; i<numVars; i++) {
		VariableToEliminate vte = (VariableToEliminate) varToVarInQuery.get(f1.getVariables()[i]);
		if (vte != null) {
//  		    System.out.print(" "+vte.var.getName());
		    vars[numVarsToElim] = vte;
		    next[numVarsToElim] = vte.factors;
		    if (vte.factors != null) {
//  			System.out.print(" (FWD) ");
			int j=0; // the index for vte in vte.factors
			while (vte.factors.vars[j] != vte) {
			    j++;
			}
			vte.factors.prev[j]=this;
		    }
		    vte.factors = this;
		    vte.numFactors++;
		    numVarsToElim++;
		}
	    }
//  	    System.out.println(". NVE="+numVarsToElim);
	    if (numVarsToElim==0) {
		finalFacs[numFinalFacs++]=f1;
	    }
	    for (int i=0; i<numVarsToElim; i++) {
		vars[i].addNeighbours(f1.getVariables());
		vars[i].recomputeSize();
	    }
	}
	    
	void remove() {
	    //System.out.println("Removing "+fac.getName()+". numVarsToElim="+numVarsToElim);
	    for (int i=0; i<numVarsToElim; i++) {
		vars[i].numFactors--;
		if (prev[i] == null) {
		    // make var i point to next
		    vars[i].factors = next[i];
		}
		else {
		    // make the previous point to next
		    int j=0;
		    while (prev[i].vars[j] != vars[i]) {
			j++;
		    }
		    prev[i].next[j]=next[i];
		}
		if (next[i] != null) {
		    // make next point to previous
		    int j=0;
		    while (next[i].vars[j] != vars[i]) {
			j++;
		    }
		    next[i].prev[j]=prev[i];
		}
	    }
	}
    }
		    
}
