package ve;

/**
 * This the the class of factors that are the normalization of other
 * factors. It is mainly uses as the last step in a compuation. It is
 * lazy in that it doesn't explicitly store the factors. The values
 * can be computed as needed using the {@link EltsIterator
 * EltsIterator}.

 * @author David Poole
 * @version 0.1 2001-01-15 
 **/
public class FactorNormalise extends Factor {

    /**
     * constructs a factor with the given variables.
     */
    public FactorNormalise(Factor f1) {
	super(f1.getVariables(),BY_NORMALIZING);
	fac1=f1;
	EltsIterator f1Itr = f1.iterator();
	sum=0;
	while (f1Itr.hasNext()) {
	    sum+=f1Itr.next();
	}
    }

    /**
     * the factor that is to be normalised.
     */
    private Factor fac1;

     /**
     * returns the factor that is being normalised
     **/
    public Factor getTheFactor() {
	return fac1;
    }
   

    /**
     * the sum of the probabilities in the factor. */
    private double sum;

    // Iterators

    /*
     * Returns an iterator over the values of the factor. This code is
     * based on the Iterator code in java.util.AbstractList.
     */
    public EltsIterator iterator() {
	return new Itr();
    }

    private class Itr implements EltsIterator {
	/** 
	 * iterator for fac1.
	 */
	EltsIterator it1 = fac1.iterator();

	public boolean hasNext() {
	    return it1.hasNext(); 
	}

	public double next() {
	    return it1.next()/sum;
	}
	
	public int currPos() {
	    return it1.currPos(); 
	}

	public void backTo(int pos) {
	    it1.backTo(pos);
	}
    }
}


