package ve;

/**
 * This the the class of factors that are created by optimizing a
 * decision variable. It is only used if the factor being optimized
 * contains a decision variable, all of the other variables are
 * parents of the decision variable and it is a utility factor.
 *
 * Copyright 2001, David Poole. All rights reserved.
 *
 * @author David Poole
 * @version 0.1 2001-06-15
 **/

public class FactorMax extends FactorStored {

    /**
     * constructs a factor with the given variables.
     *
     * @param f1 the original factor. 
     * @param vars the list of variables to be summed out. This
     * assumes that vars is a subset of f1.getVariables().  
     **/
    public FactorMax(Factor f1, Variable var) {
	super(remove(f1.getVariables(),var),BY_MAXIMIZING);
	int vpos=0;
	int prevals=1;
	int[] thePolicyFunction=new int[this.size()];
	while (f1.getVariables()[vpos] != var) {
	    prevals *= f1.getVariables()[vpos++].getDomain().length;
	}
	int varvals=var.getDomain().length;
	int postvals=1;
	for (int i=vpos+1; i<f1.getVariables().length; i++) {
	    postvals *= f1.getVariables()[i].getDomain().length;
	}
	EltsIterator f1Iter = f1.iterator();
	int pos=0;
	for (int prepos=0; prepos<prevals; prepos++) {
	    int firstpos=pos;
	    for (int postpos=0; postpos<postvals; postpos++) {
		factorValues[pos++]=f1Iter.next();
	    }
	    for (int varpos=1; varpos<varvals; varpos++) {
		pos=firstpos;
		for (int postpos=0; postpos<postvals; postpos++) {
		    double nextVal=f1Iter.next();
		    if (factorValues[pos]<nextVal) {
			factorValues[pos]=nextVal;
			thePolicyFunction[pos]=varpos;
		    }
		    pos++;
		}
		
	    }
	}
	policyFunction = new FactorDeterministic(this.getVariables(),var,thePolicyFunction);
    }

    private FactorDeterministic policyFunction; 

    /** 
     * returns an array of value index for the part of the optimal
     * policy for this decision node.
     **/
    public FactorDeterministic getPolicyFunction() {
	return policyFunction;
    }


    /**
     * returns the array representing the set difference of the variables.
     *
     * @param vars1 an ordered list of variables.
     * @param vars2 an ordered list of variables.
     * @return the elements of vars1 not in vars2.
     */
    public static Variable[] remove(Variable[] vars1, Variable var) {
	Variable[] vars = new Variable[vars1.length-1];
	int pos=0;  // number of elements currently in the difference
	int i1=0;   // next position in vars1
	while (i1<vars1.length) {
	    if (vars1[i1]==var) {
		i1++;}
	    else {
		vars[pos++]=vars1[i1++]; }
	}
	return vars;
    }
}
