package ve;

/**
 * This the the class of factors that are the the result of projecting
 * another factor onto some observations.
 *
 * @author David Poole
 * @version 0.1 2001-01-29 
 * */
public class FactorAssign extends Factor {

    /**
     * constructs a factor with the given assignment.
     *
     * @param f1 the factor that is to be updated
     * @param var the variables that is assigned a value. It must
     * appear in f1.
     * @param val the value assigned to var.
     **/
    public FactorAssign(Factor f1, Variable var, int val){
	super(removeVar(f1.getVariables(),var),BY_ASSIGN);
	fact=f1;
	valAssigned=val;
	domainSizeBefore = 1;
	int pos=0;
	while (f1.getVariables()[pos].getId()<var.getId()) {
	    domainSizeBefore *= f1.getVariables()[pos++].getDomain().length;
	}
	// at this stage f1.getVariables()[pos]==var
	domainSize = var.getDomain().length;
	pos++;
	domainSizeAfter = 1;
	while (pos<f1.getVariables().length) {
	    domainSizeAfter *= f1.getVariables()[pos++].getDomain().length;
	}
    }

    private int domainSizeBefore;
    private int domainSize;
    private int domainSizeAfter;
    private int valAssigned;
    private Factor fact;

    /*
     * Returns an iterator over the values of the factor. This is like
     * the iterator in FactorExpand.  */
    public EltsIterator iterator() {
	return new Itr();
    }
    
    private class Itr implements EltsIterator {
	private int posBefore=0;
	private int posAfter=0;
	Itr(){
	    factItr = fact.iterator();
	    factItr.backTo(valAssigned*domainSizeAfter);
	    //System.out.println("FactorAssign$itr; domBefore="+domainSizeBefore+" domAfter="+domainSizeAfter);
	}

	/** 
	 * iterator for fact.
	 */
	private EltsIterator factItr;

	public boolean hasNext() {
	    //System.out.println("FactorAssign$itr.hasNext; posBefore="+posBefore+" posAfter="+posAfter);

	    return posAfter<domainSizeAfter || posBefore<domainSizeBefore-1;
	}

	public double next() {
	    if (posAfter++ < domainSizeAfter) {
		return factItr.next();
	    }
	    else {
		factItr.backTo((++posBefore*domainSize+valAssigned)*domainSizeAfter);
		posAfter=1;
		return factItr.next();
	    }
	}
	
	public int currPos() {
	    return posBefore*domainSizeAfter+posAfter;

	}

	public void backTo(int pos) {
	    posAfter=pos%domainSizeAfter;
	    posBefore=pos/domainSizeAfter;
	    factItr.backTo((posBefore*domainSize+valAssigned)*domainSizeAfter+posAfter);
	}

	    
	
    }

    /**
     * removes a variable from an array of variables in which it appears.
     *
     * @param vars an array of variables, in order
     * @param var a variables appearing in vars
     * @return the array of variables with var removed
     **/
    private static Variable[] removeVar(Variable[] vars,Variable var) {
	Variable[] result = new Variable[vars.length-1];
	int pos=0;
	while (vars[pos].getId()<var.getId()) {
	    result[pos]=vars[pos++];
	}
	// at this stage vars[pos]==var
	while (pos<result.length) {
	    result[pos]=vars[++pos];
	}
	return result;
    }
}
