package ve;

/**
 * An iterator over the elements of a factor.  This follows the basic
 * abstract Iterator interface, but doesn't throw an exception. (It
 * assumes it will be used properly.)  I don't use the standard
 * interface because I extend it to go back to a positon. This is
 * needed for {@link FactorExpand}.

 * @author David Poole
 * @version 0.1 2000-01-12 */

public interface EltsIterator {
    /**
     * Returns true if the iterator has more elements.
     *
     * @return true if the iterator has more elements.  */
    boolean hasNext();

    /**
     * Returns the next element in the iteration.
     *
     * @return the next element in the iteration.
     */
    double next();

    /**
     * Returns the current position in the iteration. The position is
     * the index in the sequence of values. That is the position where
     * the next value will be taken out of. This will even be true
     * when the factor isn't represented as an array.
     *
     * @return the current position in the iteration.  */
    int currPos();

    /**
     * Goes back to the given position in the iteration.
     *
     * @param pos the position in the iteration returned by <tt>currPos</tt>
     */
    void backTo(int pos);

}
