package ve;

import java.util.*;

/**
 * A DecisionNetwork that is constructed from the CIspace format.
 **/

public class DecisionNetworkFromCIspaceFormat extends DecisionNetwork {

    /**
     * constructs a belief network for the corresponding variables
     **/
    public DecisionNetworkFromCIspaceFormat(Variable[] vars, int numVars) {
	super(vars,numVars);
    }

    /**
     * constructs a decision network from the extended CIspace
     * representation.  The extended representation lets us have
     * indexes or names as the parents. It assumes that the names are
     * not numbers (otherwise it assumes they are the indexes).
     *
     * @param s string representation of the decision network
     * @param maxVariables the maximum number of variables allowed 
     **/
    public DecisionNetworkFromCIspaceFormat(String s,int maxVariables){
	super();
	probFactors = new Factor[maxVariables];
	variables = new Variable[maxVariables];
	StringTokenizer graphTokenizer = new StringTokenizer(s,";");
        while ( graphTokenizer.hasMoreTokens() ) {
	    String inString = graphTokenizer.nextToken();
	    inString = inString.trim();
	    if (inString.indexOf("endBayesGraph") == -1) {
		String dataString = inString.substring (4,inString.length());
		StringTokenizer nodeTokenizer = 
		    new StringTokenizer(dataString,"/");
		String nodeName = nodeTokenizer.nextToken();
		String xpos = nodeTokenizer.nextToken();
		String ypos = nodeTokenizer.nextToken();
		String domainString = nodeTokenizer.nextToken();
		variables[numVariables]= new Variable(nodeName,stringToStringArray(domainString,maxDomainSize));
		stringToVar.put(nodeName,variables[numVariables]);
		String parentsString = nodeTokenizer.nextToken();
		String probsString = nodeTokenizer.nextToken();
		if (inString.charAt(0)=='n') {
		    // random node
		    probFactors[numProbFactors] = 
			new FactorCPT(
				      stringToFamily(parentsString,numVariables,maxFactorSize),
				      probsString);
		    if (! sorted(probFactors[numProbFactors].getVariables())) {
			Variable[] vars=new Variable[probFactors[numProbFactors].getVariables().length];
			for (int i=0; i<probFactors[numProbFactors].getVariables().length;i++) {
			    vars[i]=probFactors[numProbFactors].getVariables()[i];
			}
			// Arrays.sort(vars);  this is what it should be
			mysort(vars);
			probFactors[numProbFactors]=new 
			    FactorReorder(probFactors[numProbFactors],vars);
		    }
		    numVariables++;
		    numProbFactors++;
		}
		else if (inString.charAt(0)=='d') {
		    // decision node....we should probably remember the parents
		    numVariables++;
		}
		else if (inString.charAt(0)=='v') {
		    // value node
		    probFactors[numProbFactors] = 
			new FactorCPT(
				      stringToParents(parentsString,numProbFactors,maxFactorSize),
				      probsString);
		    if (! sorted(probFactors[numProbFactors].getVariables())) {
		    Variable[] vars=new Variable[probFactors[numVariables].getVariables().length];
		    for (int i=0; i<probFactors[numVariables].getVariables().length;i++) {
			vars[i]=probFactors[numVariables].getVariables()[i];
		    }
		    //Arrays.sort(vars);  this is what it should be
		    mysort(vars);
		    probFactors[numProbFactors]=new 
			FactorReorder(probFactors[numProbFactors],vars);
		    }
		    numVariables++;
		    numProbFactors++;
		}
	    }
	}
    }

    /** 
     * A new constructor that takes in a vector of different sorts of
     * variables instead of a string representation. Essentially a
     * copy of the other constructor.  
     **/

//      public DecisionNetwork(Vector curVariables, int maxVariables) {
	
//  	variables = new Variable[maxVariables];
//  	probFactors = new Factor[maxVariables];
//  	numVariables = 0;
//  	numProbFactors = 0;
//  	for (int j = 0; j< curVariables.size(); j++) {
//         	    Variable v = (Variable)((BayesNode)curVariables.elementAt(j)).getVariable();
//  	    variables[numVariables] = v;
//  	    //variables[numVariables] = new Variable(v.getName(),v.getDomain());
//  	    //stringToVar.put(v.getName(),variables[numVariables]);
//  	    stringToVar.put(v.getName(),v);

//  	    if (v.getType() == BayesNode.REGULAR_NODE) {
//  		probFactors[numProbFactors] = new FactorCPT(v.getParentsArray(), v.getProbsArray());
//  		if (! sorted(probFactors[numProbFactors].getVariables())) {
//  		    Vector vars = new Vector(probFactors[numProbFactors].getVariables().length);
//  		    for (int i = 0; i<probFactors[numProbFactors].getVariables().length;i++) {
//  			vars.add(probFactors[numProbFactors].getVariables()[i]);
//  		    }
//  		    Collections.sort(vars);
//  		    Variable[] sortedVars = new Variable[probFactors[numProbFactors].getVariables().length];
//  		    Iterator varsItr = vars.iterator();
//  		    for (int i = 0; i<probFactors[numProbFactors].getVariables().length; i++) {
//  			sortedVars[i] = (Variable) varsItr.next();
//  		    }
//  		    probFactors[numProbFactors] = new FactorReorder(probFactors[numProbFactors],sortedVars);
//  		}
//  		numVariables++;
//  		numProbFactors++;
//  	    }
//  	    else if (v.getType() == BayesNode.DECISION_NODE) {
//  		// remember parents? ask david what he did here
//  		numVariables++;
//  	    }
//  	    else if (v.getType() == BayesNode.VALUE_NODE) {
//  		probFactors[numProbFactors] = new FactorCPT(v.getParentsArray(), v.getProbsArray());
		
//  		if (! sorted(probFactors[numProbFactors].getVariables())) {
//  		    Vector vars = new Vector(probFactors[numProbFactors].getVariables().length);
//  		    for (int i=0; i<probFactors[numProbFactors].getVariables().length; i++){
//  			vars.add(probFactors[numProbFactors].getVariables()[i]);
//  		    }
//  		    Collections.sort(vars);
//  		    Variable[] sortedVars = new Variable[probFactors[numProbFactors].getVariables().length];
//  		    Iterator varsItr = vars.iterator();
//  		    for (int i=0; i<probFactors[numProbFactors].getVariables().length;i++){
//  			sortedVars[i] = (Variable) varsItr.next();
//  		    }
//  		    probFactors[numProbFactors] = new FactorReorder(probFactors[numProbFactors],sortedVars);
//  		}
//  		numVariables++;
//  		numProbFactors++;
//  	    }
//  	}
    
//      }


    static private boolean sorted(Variable[] varray) {
	for (int i=1; i<varray.length; i++) {
	    if (varray[i-1].getId() >= varray[i].getId()) {
		return false;
	    }
	}
	return true;
    }

    static private String[] stringToStringArray(String str, int maxSize) {
	String[] tempResult = new String[maxSize];
	int lpar = str.indexOf('[');
	int rpar = str.indexOf(']');
	StringTokenizer tokenizer = new StringTokenizer(str.substring(lpar+1,rpar),",");
	int size=0;
	while (tokenizer.hasMoreTokens()) {
	    tempResult[size++]=tokenizer.nextToken().trim();
	}
	String[] result = new String[size];
	for (int i=0; i<size; i++) {
	    result[i]=tempResult[i];
	}
	return result;
    }

    /**
     * given the string, return the family.
     *
     * @param str the string containing the parents' index or name
     * @param index the index of the current variable
     * @param maxSize the maximum factor size
     **/
    protected Variable[] stringToFamily(String str, int index, int maxSize) {
	Variable[] tempResult = new Variable[maxSize];
	int lpar = str.indexOf('[');
	int rpar = str.indexOf(']');
	StringTokenizer tokenizer = new StringTokenizer(str.substring(lpar+1,rpar),",");
	int size=0;
	while (tokenizer.hasMoreTokens()) {
	    String nextToken = tokenizer.nextToken().trim();
	    try {
		tempResult[size]=variables[Integer.parseInt(nextToken)];
	    }
	    catch( Exception e) {   // not an integer; parent is the Name.
		// This should probably check the exception to make sure 
		// it is of the right type.
		Variable par = (Variable) stringToVar.get(nextToken);
		if (par==null) {  // should throw exception
		    System.out.println("Parent of node "+variables[index].getName()+" is undefined.");
		}
		tempResult[size]=par;
	    }
	    size++;
      	}
	Variable[] result = new Variable[size+1];
	for (int i=0; i<size; i++) {
	    result[i]=tempResult[i];
	}
	result[size]=variables[index];
	return result;
    }


    /**
     * given the string, return the parents.
     *
     * @param str the string containing the parents' index or name
     * @param index the index of the current variable
     * @param maxSize the maximum factor size
     **/
    protected Variable[] stringToParents(String str, int index, int maxSize) {
	Variable[] tempResult = new Variable[maxSize];
	int lpar = str.indexOf('[');
	int rpar = str.indexOf(']');
	StringTokenizer tokenizer = new StringTokenizer(str.substring(lpar+1,rpar),",");
	int size=0;
	while (tokenizer.hasMoreTokens()) {
	    String nextToken = tokenizer.nextToken().trim();
	    try {
		tempResult[size]=variables[Integer.parseInt(nextToken)];
	    }
	    catch( Exception e) {   // not an integer; parent is the Name.
		// This should probably check the exception to make sure 
		// it is of the right type.
		Variable par = (Variable) stringToVar.get(nextToken);
		if (par==null) {  // should throw exception
		    System.out.println("Parent of node "+variables[index].getName()+" is undefined.");
		}
		tempResult[size]=par;
	    }
	    size++;
      	}
	Variable[] result = new Variable[size];
	for (int i=0; i<size; i++) {
	    result[i]=tempResult[i];
	}
	return result;
    }

}
