package ve;

/**
   This class is the class of variables.
   @author David Poole
 */
public class Variable //implements Comparable   // commented out for Java 1.1
{

    /** the external name of the variable */
    protected String name;

    /** returns the external name of the variable */
    public String getName() {
	return name;
    }

    /** domain is the array of values this variable can take. */
    protected String[] domain;

    /** returns the domain, the array of values this variable can take. */
    public String[] getDomain() {
	return domain;
    }

    /** 
     * the identifier of the next variable; also the number of
     * variables assigned. */
    private static int nextId=0;

    /** 
     * the unique identifier of the variable.
     */
    private int uniqueId;

    /** Variable constructor creates a variable.
     *
     * @param varName string representation of the name
     * @param domainString a string consisting of the domain elements
     * separated by commas. */
    public Variable(String varName, String[] domainArray) {
	uniqueId=nextId++;
	name = varName;
	this.domain = domainArray;
    }
    
    /** get the unique identifier of the variable */
    public int getId() {
	return uniqueId;
    }

    /** compares two Variables. */
    public int compareTo(Object var) {
	return uniqueId - ((Variable) var).getId();
    }
}

