package ve;

import java.io.*;

/**
 * a factor that is the result of a query.
 *
 * @author David Poole
 * @version 0.2 2001-04-04 */
public class QueryIndexed {

    /**
     * constructs the factor that answers the specific query.
     *
     * @param queryVars the array of variables being queried. These
     * are assumed to be in order and must be a subset of the
     * variables in bnet.  
     * @param bnet a belief network.
     * @param observedVars the array of variables that have observed
     * values. These are assumed to be in order and must be a subset
     * of the variables in bnet.  
     * @param ObservedVals the array of values for the corresponding
     * observed values. Each value ObservedVals[i] is the index into
     * ObservedVars[i].domain. 
     **/
    public QueryIndexed(Variable[] queryVars, DecisionNetwork dnet, 
	  Variable[] observedVars, int[] observedVals) {
	Variable[] toSumOut = determineToSumOut(dnet.getVariables(),dnet.getNumVariables(),queryVars,observedVars);
	Factor[] observedFactors= new Factor[dnet.getNumProbFactors()];
	if (observedVars.length>0) {
	    for (int i=0;i<dnet.getNumProbFactors();i++) {
		observedFactors[i] = new FactorObserved(dnet.getProbFactors()[i],
						       observedVars,observedVals);
	    }
	}
	else {
	    observedFactors=dnet.getProbFactors();
	}
	FactorStoreIndexed factors = 
	    new FactorStoreIndexed(toSumOut,
				   observedFactors,
				   dnet.getNumProbFactors());
	while (factors.hasNext()) {
	    Variable elimVar = factors.next();
	    System.out.println("\nEliminating "+elimVar.getName());
	    FactorIterator toMultiply = factors.emunFactorsRemoved();
	    Factor prod = toMultiply.next();   // can this ever fail??
	    System.out.print("Multiplying factors: "+prod.getName());
	    while (toMultiply.hasNext()) {
		Factor nextProd =toMultiply.next();
		System.out.print(", "+nextProd.getName());
		prod = new FactorTimes(prod,nextProd);
	    }
	    System.out.println(".");
	    // we should really find out what other variables can be
	    // eliminated at the same time
	    Variable[] sumOut = {elimVar};
	    Factor newFac =new FactorSumOut(prod,sumOut);
	    System.out.println("Creating factor "+newFac.getName());
	    factors.addFactor(newFac);
	}
	FactorIterator remainingFactors = factors.emunFactorsRemaining();
	result= remainingFactors.next();
	while (remainingFactors.hasNext()) {
	    result = new FactorTimes(result,remainingFactors.next());
	}
	normresult = new FactorNormalise(result);
    }



    private Factor result;
    private Factor normresult;

    /** 
     * gets the result of the query.  */
    Factor getResult() {
	return normresult;
    }

    Factor getUnNormResult() {
	return result;
    }

    private Variable[] determineToSumOut(Variable[] allVars, 
					 int numVars,
					 Variable[] queryVars, 
					 Variable[] observedVars) {
	Variable[] res = new Variable[numVars-queryVars.length-observedVars.length];
	int allpos=0;
	int qpos=0;
	int opos=0;
	int respos=0;
	while (allpos< numVars) {
	    if (qpos<queryVars.length && queryVars[qpos]==allVars[allpos]) {
		qpos++;
		allpos++;
	    }
	    else if (opos<observedVars.length && observedVars[opos]==allVars[allpos]) {
		opos++;
		allpos++;
	    }
	    else {
		res[respos++]=allVars[allpos++];
	    }
	}
	return res;
    }
    
}
