package ve;

import java.io.*;

/**
 * a factor that is the result of a query.
 *
 * @author David Poole
 * @version 0.2 2001-04-04 */
public class Query {

    /**
     * constructs the factor that answers the specific query.
     *
     * @param queryVars the array of variables being queried. These
     * are assumed to be in order and must be a subset of the
     * variables in bnet.  
     * @param bnet a belief network.
     * @param observedVars the array of variables that have observed
     * values. These are assumed to be in order and must be a subset
     * of the variables in bnet.  
     * @param ObservedVals the array of values for the corresponding
     * observed values. Each value ObservedVals[i] is the index into
     * ObservedVars[i].domain. 
     **/
    public Query(Variable[] queryVars, BeliefNetwork bnet, 
	  Variable[] observedVars, int[] observedVals) {
	FactorStore factors = new FactorStore(bnet.getProbFactors(),bnet.getNumVariables(),bnet.getVariables(),bnet.getNumVariables());
	factors.observe(observedVars, observedVals);
	factors.setQuery(queryVars);
	factors.removeIrrelevantVariables();
	VariableIterator toSumOut = factors.variableSelector("random");
	while (toSumOut.hasNext()) {
	    Variable elimVar = toSumOut.next();
	    FactorIterator toMultiply = factors.emunFactorsContaining(elimVar);
	    Factor prod = toMultiply.next();   // can this ever fail??
	    while (toMultiply.hasNext()) {
		prod = new FactorTimes(prod,toMultiply.next());
	    }
	    // we should find out what other variables can be
	    // eliminated at the same time
	    Variable[] sumOut = {elimVar};
	    factors.add(new FactorSumOut(prod,sumOut));
	}
	FactorIterator remainingFactors = factors.emunFactors();
	result= remainingFactors.next();
	while (remainingFactors.hasNext()) {
	    result = new FactorTimes(result,remainingFactors.next());
	}
	normresult = new FactorNormalise(result);
    }


    /**
     * constructs the factor that answers the specific query for a
     * given elimination ordering.
     *
     * @param queryVars the array of variables being queried. These
     * are assumed to be in order and must be a subset of the
     * variables in bnet.  
     * @param bnet a belief network.
     * @param observedVars the array of variables that have observed
     * values. These are assumed to be in order and must be a subset
     * of the variables in bnet.  
     * @param ObservedVals the array of values for the corresponding
     * observed values. Each value ObservedVals[i] is the index into
     * ObservedVars[i].domain. 
     * @param ElimOrd the string of variables that specifies the elimination ordering. We assume this is correct.
     **/
    public Query(Variable[] queryVars, BeliefNetwork bnet, 
	  Variable[] observedVars, int[] observedVals, String[] eo) {
	FactorStore factors = new FactorStore(bnet.getProbFactors(),bnet.getNumVariables(),bnet.getVariables(),bnet.getNumVariables());
	factors.observe(observedVars, observedVals);
	factors.setQuery(queryVars);
	factors.removeIrrelevantVariables();
	Variable[] elimOrd = new Variable[eo.length];
	for (int i=0; i< eo.length; i++) {
	    elimOrd[i]=(Variable) bnet.getStringToVar().get(eo[i]);
	}
	VariableIterator toSumOut = factors.variableSelector(elimOrd);
	while (toSumOut.hasNext()) {
	    Variable elimVar = toSumOut.next();
	    System.out.println("Eliminating "+elimVar.getName());
	    FactorIterator toMultiply = factors.emunFactorsContaining(elimVar);
	    Factor prod = toMultiply.next();   // can this ever fail??
	    while (toMultiply.hasNext()) {
		prod = new FactorTimes(prod,toMultiply.next());
	    }
	    // we should find out what other variables can be
	    // eliminated at the same time
	    Variable[] sumOut = {elimVar};
	    FactorSumOut newFactor = new FactorSumOut(prod,sumOut);
	    System.out.print("Creating factor on [");
	    for (int i=0; i<newFactor.getVariables().length; i++) {
		System.out.print(" "+newFactor.getVariables()[i].getName());
	    }
	    System.out.println("]");
	    factors.add(newFactor);
	}
	FactorIterator remainingFactors = factors.emunFactors();
	result= remainingFactors.next();
	while (remainingFactors.hasNext()) {
	    result = new FactorTimes(result,remainingFactors.next());
	}
	normresult = new FactorNormalise(result);
    }

    private Factor result;
    private Factor normresult;

    /** 
     * gets the result of the query.  */
    Factor getResult() {
	return normresult;
    }

    Factor getUnNormResult() {
	return result;
    }
}
