package ve;

/**
 * This the the class of factors that can be updated from generalised rules.
 *
 * @author David Poole
 * @version 0.1 2001-05-12
 **/
public class FactorUpdatable extends FactorStored {

    /**
     * constructs a factor with the given variables.
     *
     * @param vars the list of variables
     * @param initProbs the initial Probability for each node
     **/
    public FactorUpdatable(Variable[] vars, double initProb) {
	super(vars,BY_UPDATABLE);
	for (int i=0; i<this.size(); i++) {
	    factorValues[i]=initProb;
	}
    }

    /**
     * updates every stored value corresponding to the rule. This must
     * also update all of the values.
     *
     * @param pos the position in the array to be updated
     * @param val the new value
     **/
    public void update(int pos, double val) {
	factorValues[pos]=val;
    }

}
