package ve;

/**
 * This the the class of factors that are the reordering of other
 * factors.  Note that the other operations assume a standard
 * ordering. This class is designed for moving between display formats
 * and the internal format.

 * @author David Poole
 * @version 0.1 2001-02-16 
 **/
public class FactorReorder extends FactorStored {

    /**
     * constructs a factor with values given by f1 and the order given
     * by newOrder.
     *
     * @param f1 the factor to be reordered
     * @param newOrder the new ordering of the variables
     **/
    public FactorReorder(Factor f1, Variable[] newOrder) {
	super(newOrder,BY_REORDERING);

	// newBase[i] is the base of f1.getVariables()[i] in newOrder
	int[] newBase = new int[newOrder.length];
	int base=1;
	for (int i=newOrder.length-1; i>=0; i--) {
	    // i is the position in the new ordering
	    boolean notFound=true;
	    for (int j=0; notFound && j<newOrder.length; j++) {
		if (f1.getVariables()[j]==newOrder[i]) {
		    newBase[j]=base;
		    base *= newOrder[i].getDomain().length;
		    notFound=false;
		}
	    }
	}
	//  go through the values in f1 and put them in the right place
	int[] oldIndex = new int[newOrder.length];
	int newIndex=0;
	EltsIterator f1Itr = f1.iterator();
	while (f1Itr.hasNext()) {
	    factorValues[newIndex]=f1Itr.next();
	    boolean incj = true;
	    for (int j=newOrder.length-1; incj && j>=0; j--) {
		if (++oldIndex[j]==f1.getVariables()[j].getDomain().length) {
		    oldIndex[j]=0;
		    newIndex -= (f1.getVariables()[j].getDomain().length-1)*newBase[j];
		}
		else {
		    newIndex += newBase[j];
		    incj=false;
		}
	    }
	}
    }

}


