package ve;

/**
 * This the the class of factors that are the sum of other factors. It
 * is lazy in that it doesn't explicitly store the factors. The values
 * can be computed as needed using the {@link EltsIterator
 * EltsIterator}. This is the the same as {@link FactorTimes} except
 * it uses + instead of *.

 * @author David Poole
 * @version 0.1 2001-04-03 */
public class FactorPlus extends Factor {

    /**
     * constructs a factor with the given variables.
     */
    public FactorPlus(Factor f1, Factor f2) {
	super(unionVars(f1.getVariables(),f2.getVariables()),BY_PLUS);
	if (f1.getVariables().length==this.getVariables().length) {
	    fac1=f1;}
	else {
	    fac1 = new FactorExpand(f1, this.getVariables());}
	if (f2.getVariables().length==this.getVariables().length) {
	    fac2=f2;}
	else {
	    fac2 = new FactorExpand(f2, this.getVariables());}
//  	System.out.println("\nFactor Plus Adding:");
//  	f1.print();
//  	f2.print();
//  	System.out.println("\nFactor Plus Result:");
//  	this.print();
    }

    /**
     * the factors that are to be multiplied point by point.
     */
    private Factor fac1,fac2;

    // Iterators

    /*
     * Returns an iterator over the values of the factor. This code is
     * based on the Iterator code in java.util.AbstractList.
     */
    public EltsIterator iterator() {
	return new Itr();
    }

    private class Itr implements EltsIterator {
	/** 
	 * iterator for fac1.
	 */
	EltsIterator it1 = fac1.iterator();

	/** 
	 * iterator for fac2.
	 */
	EltsIterator it2 = fac2.iterator();

	public boolean hasNext() {
	    boolean val=it1.hasNext();   // the same value as it2.hasNext
	    //System.out.println("FactorPlus hasNext(): "+val);
	    return val;
	}

	public double next() {
	    double val=it1.next()+it2.next();
	    //System.out.println("FactorPlus next(): "+val);
	    return val;
	}
	
	public int currPos() {
	    return it1.currPos();   // the same value as it2.currPos
	}

	public void backTo(int pos) {
	    it1.backTo(pos);
	    it2.backTo(pos);
	}
    }
    /**
     * returns the array representing the union of the variables.
     */
    private static Variable[] unionVars(Variable[] vars1, Variable[] vars2) {
	Variable[] vars = new Variable[vars1.length+vars2.length];
	int pos=0;  // number of elements currently in the union;
	int i1=0;   // next position in vars1
	int i2=0;   // 
	while (i1<vars1.length && i2<vars2.length) {
	    if (vars1[i1]==vars2[i2]) {
		vars[pos++]=vars1[i1++]; i2++;}
	    else if (vars1[i1].getId() < vars2[i2].getId()) {
		vars[pos++]=vars1[i1++]; }
	    else { 
                vars[pos++]=vars2[i2++]; }
	}
	while (i1<vars1.length) {
	    vars[pos++]=vars1[i1++];}
	while (i2<vars2.length) {
	    vars[pos++]=vars2[i2++];}
        Variable[] result = new Variable[pos];
	for (int i=0; i<pos; i++) {
	    result[i]=vars[i];}
	return result;
    }
}


