package ve;

import java.util.*;

/**
 *  Factors that represent conditional probabilty tables. These
 *  explictly store the values in a table. We need to be able to read
 *  these in from various formats, including standard representations,
 *  onscreen display and a native format. We may even want to output
 *  them in a different form.

 * @author David Poole
 * @version 0.1 2000-01-10 
 */
public class FactorCPT extends FactorStored {

    public FactorCPT(Variable[] vars, String valuesString) {
	super(vars,BY_CPT);
	this.factorValues=stringToValues(valuesString,this.size());
    }

    /**
     * an extra constructor so it can take in the actual values
     * instead of a string representation of them.
     **/

    public FactorCPT(Variable[] vars, double[] valuesArray) {
	super(vars,BY_CPT);
	factorValues = valuesArray;
    }

    static private double[] stringToValues(String str, int size) {
	double[] result = new double[size];
	int lpar = str.indexOf('[');
	int rpar = str.indexOf(']');
	StringTokenizer tokenizer = new StringTokenizer(str.substring(lpar+1,rpar),",");
	int i=0;
	while (tokenizer.hasMoreTokens()) {
	    result[i++]=(Double.valueOf(tokenizer.nextToken())).doubleValue();
	}
	return result;
    }
}
