belief network "Alarm network by Beinlich et al."

node Anaphylaxis
{
    name : "Anaphylaxis";
    type : discrete[2] = 
    {
        "True",
        "False"
    };
    position : (355, 150);
}

node Intubation
{
    name : "Intubation";
    type : discrete[3] = 
    {
        "Normal",
        "Esophageal",
        "OneSided"
    };
    position : (718, 52);
}

node KinkedTube
{
    name : "KinkedTube";
    type : discrete[2] = 
    {
        "True",
        "False"
    };
    position : (868, 52);
}

node Disconnect
{
    name : "Disconnect";
    type : discrete[2] = 
    {
        "True",
        "False"
    };
    position : (1001, 115);
}

node MinVolSet
{
    name : "MinVolSet";
    type : discrete[3] = 
    {
        "Low",
        "Normal",
        "High"
    };
    position : (986, 29);
}

node VentMach
{
    name : "VentMach";
    type : discrete[4] = 
    {
        "Zero",
        "Low",
        "Normal",
        "High"
    };
    position : (944, 77);
}

node VentTube
{
    name : "VentTube";
    type : discrete[4] = 
    {
        "Zero",
        "Low",
        "Normal",
        "High"
    };
    position : (911, 130);
}

node VentLung
{
    name : "VentLung";
    type : discrete[4] = 
    {
        "Zero",
        "Low",
        "Normal",
        "High"
    };
    position : (819, 142);
}

node VentAlv
{
    name : "VentAlv";
    type : discrete[4] = 
    {
        "Zero",
        "Low",
        "Normal",
        "High"
    };
    position : (697, 160);
}

node ArtCO2
{
    name : "ArtCO2";
    type : discrete[3] = 
    {
        "Low",
        "Normal",
        "High"
    };
    position : (556, 240);
}

node TPR
{
    name : "TPR";
    type : discrete[3] = 
    {
        "Low",
        "Normal",
        "High"
    };
    position : (299, 206);
}

node Hypovolemia
{
    name : "Hypovolemia";
    type : discrete[2] = 
    {
        "True",
        "False"
    };
    position : (97, 49);
}

node LVFailure
{
    name : "LVFailure";
    type : discrete[2] = 
    {
        "True",
        "False"
    };
    position : (205, 49);
}

node StrokeVolume
{
    name : "StrokeVolume";
    type : discrete[3] = 
    {
        "Low",
        "Normal",
        "High"
    };
    position : (205, 126);
}

node InsuffAnesth
{
    name : "InsuffAnesth";
    type : discrete[2] = 
    {
        "True",
        "False"
    };
    position : (408, 218);
}

node PulmEmbolus
{
    name : "PulmEmbolus";
    type : discrete[2] = 
    {
        "True",
        "False"
    };
    position : (541, 52);
}

node Shunt
{
    name : "Shunt";
    type : discrete[2] = 
    {
        "Normal",
        "High"
    };
    position : (575, 116);
}

node FiO2
{
    name : "FiO2";
    type : discrete[2] = 
    {
        "Low",
        "Normal"
    };
    position : (657, 115);
}

node PVSat
{
    name : "PVSat";
    type : discrete[3] = 
    {
        "Low",
        "Normal",
        "High"
    };
    position : (605, 171);
}

node SaO2
{
    name : "SaO2";
    type : discrete[3] = 
    {
        "Low",
        "Normal",
        "High"
    };
    position : (509, 195);
}

node Catechol
{
    name : "Catechol";
    type : discrete[2] = 
    {
        "Normal",
        "High"
    };
    position : (363, 297);
}

node HR
{
    name : "HR";
    type : discrete[3] = 
    {
        "Low",
        "Normal",
        "High"
    };
    position : (314, 343);
}

node CO
{
    name : "CO";
    type : discrete[3] = 
    {
        "Low",
        "Normal",
        "High"
    };
    position : (205, 368);
}

node BP
{
    name : "BP";
    type : discrete[3] = 
    {
        "Low",
        "Normal",
        "High"
    };
    position : (62, 465);
}

node LVEDVolume
{
    name : "LVEDVolume";
    type : discrete[3] = 
    {
        "Low",
        "Normal",
        "High"
    };
    position : (97, 126);
}

node CVP
{
    name : "CVP";
    type : discrete[3] = 
    {
        "Low",
        "Normal",
        "High"
    };
    position : (50, 199);
}

node ErrCauter
{
    name : "ErrCauter";
    type : discrete[2] = 
    {
        "True",
        "False"
    };
    position : (293, 423);
}

node ErrLowOutput
{
    name : "ErrLowOutput";
    type : discrete[2] = 
    {
        "True",
        "False"
    };
    position : (448, 403);
}

node ExpCO2
{
    name : "ExpCO2";
    type : discrete[4] = 
    {
        "Zero",
        "Low",
        "Normal",
        "High"
    };
    position : (640, 283);
}

node HRBP
{
    name : "HRBP";
    type : discrete[3] = 
    {
        "Low",
        "Normal",
        "High"
    };
    position : (448, 465);
}

node HREKG
{
    name : "HREKG";
    type : discrete[3] = 
    {
        "Low",
        "Normal",
        "High"
    };
    position : (204, 465);
}

node HRSat
{
    name : "HRSat";
    type : discrete[3] = 
    {
        "Low",
        "Normal",
        "High"
    };
    position : (356, 465);
}

node History
{
    name : "History";
    type : discrete[2] = 
    {
        "True",
        "False"
    };
    position : (292, 99);
}

node MinVol
{
    name : "MinVol";
    type : discrete[4] = 
    {
        "Zero",
        "Low",
        "Normal",
        "High"
    };
    position : (791, 288);
}

node PAP
{
    name : "PAP";
    type : discrete[3] = 
    {
        "Low",
        "Normal",
        "High"
    };
    position : (488, 115);
}

node PCWP
{
    name : "PCWP";
    type : discrete[3] = 
    {
        "Low",
        "Normal",
        "High"
    };
    position : (143, 199);
}

node Press
{
    name : "Press";
    type : discrete[4] = 
    {
        "Zero",
        "Low",
        "Normal",
        "High"
    };
    position : (868, 286);
}

probability (Anaphylaxis)
{
    0.01000000, 0.99000000;
}

probability (Intubation)
{
    0.92000000, 0.03000000, 0.05000000;
}

probability (KinkedTube)
{
    0.04000000, 0.96000000;
}

probability (Disconnect)
{
    0.05000000, 0.95000000;
}

probability (MinVolSet)
{
    0.01000000, 0.98000000, 0.01000000;
}

probability (VentMach | MinVolSet)
{
    (0) : 0.01000000, 0.97000000, 0.01000000, 0.01000000;
    (1) : 0.01000000, 0.01000000, 0.97000000, 0.01000000;
    (2) : 0.01000000, 0.01000000, 0.01000000, 0.97000000;
}

probability (VentTube | Disconnect, VentMach)
{
    (0, 0) : 0.97000000, 0.01000000, 0.01000000, 0.01000000;
    (0, 1) : 0.97000000, 0.01000000, 0.01000000, 0.01000000;
    (0, 2) : 0.97000000, 0.01000000, 0.01000000, 0.01000000;
    (0, 3) : 0.97000000, 0.01000000, 0.01000000, 0.01000000;
    (1, 0) : 0.97000000, 0.01000000, 0.01000000, 0.01000000;
    (1, 1) : 0.01000000, 0.97000000, 0.01000000, 0.01000000;
    (1, 2) : 0.01000000, 0.01000000, 0.97000000, 0.01000000;
    (1, 3) : 0.01000000, 0.01000000, 0.01000000, 0.97000000;
}

probability (VentLung | KinkedTube, Intubation, VentTube)
{
    (0, 0, 0) : 0.97000000, 0.01000000, 0.01000000, 0.01000000;
    (0, 0, 1) : 0.95000000, 0.03000000, 0.01000000, 0.01000000;
    (0, 0, 2) : 0.40000000, 0.58000000, 0.01000000, 0.01000000;
    (0, 0, 3) : 0.30000000, 0.68000000, 0.01000000, 0.01000000;
    (0, 1, 0) : 0.97000000, 0.01000000, 0.01000000, 0.01000000;
    (0, 1, 1) : 0.97000000, 0.01000000, 0.01000000, 0.01000000;
    (0, 1, 2) : 0.97000000, 0.01000000, 0.01000000, 0.01000000;
    (0, 1, 3) : 0.97000000, 0.01000000, 0.01000000, 0.01000000;
    (0, 2, 0) : 0.97000000, 0.01000000, 0.01000000, 0.01000000;
    (0, 2, 1) : 0.95000000, 0.03000000, 0.01000000, 0.01000000;
    (0, 2, 2) : 0.50000000, 0.48000000, 0.01000000, 0.01000000;
    (0, 2, 3) : 0.30000000, 0.68000000, 0.01000000, 0.01000000;
    (1, 0, 0) : 0.97000000, 0.01000000, 0.01000000, 0.01000000;
    (1, 0, 1) : 0.01000000, 0.97000000, 0.01000000, 0.01000000;
    (1, 0, 2) : 0.01000000, 0.01000000, 0.97000000, 0.01000000;
    (1, 0, 3) : 0.01000000, 0.01000000, 0.01000000, 0.97000000;
    (1, 1, 0) : 0.97000000, 0.01000000, 0.01000000, 0.01000000;
    (1, 1, 1) : 0.97000000, 0.01000000, 0.01000000, 0.01000000;
    (1, 1, 2) : 0.97000000, 0.01000000, 0.01000000, 0.01000000;
    (1, 1, 3) : 0.97000000, 0.01000000, 0.01000000, 0.01000000;
    (1, 2, 0) : 0.97000000, 0.01000000, 0.01000000, 0.01000000;
    (1, 2, 1) : 0.01000000, 0.97000000, 0.01000000, 0.01000000;
    (1, 2, 2) : 0.01000000, 0.01000000, 0.97000000, 0.01000000;
    (1, 2, 3) : 0.01000000, 0.01000000, 0.01000000, 0.97000000;
}

probability (VentAlv | Intubation, VentLung)
{
    (0, 0) : 0.97000000, 0.01000000, 0.01000000, 0.01000000;
    (0, 1) : 0.01000000, 0.97000000, 0.01000000, 0.01000000;
    (0, 2) : 0.01000000, 0.01000000, 0.97000000, 0.01000000;
    (0, 3) : 0.01000000, 0.01000000, 0.01000000, 0.97000000;
    (1, 0) : 0.97000000, 0.01000000, 0.01000000, 0.01000000;
    (1, 1) : 0.01000000, 0.97000000, 0.01000000, 0.01000000;
    (1, 2) : 0.01000000, 0.01000000, 0.97000000, 0.01000000;
    (1, 3) : 0.01000000, 0.01000000, 0.01000000, 0.97000000;
    (2, 0) : 0.97000000, 0.01000000, 0.01000000, 0.01000000;
    (2, 1) : 0.03000000, 0.95000000, 0.01000000, 0.01000000;
    (2, 2) : 0.01000000, 0.94000000, 0.04000000, 0.01000000;
    (2, 3) : 0.01000000, 0.88000000, 0.10000000, 0.01000000;
}

probability (ArtCO2 | VentAlv)
{
    (0) : 0.01000000, 0.01000000, 0.98000000;
    (1) : 0.01000000, 0.01000000, 0.98000000;
    (2) : 0.04000000, 0.92000000, 0.04000000;
    (3) : 0.90000000, 0.09000000, 0.01000000;
}

probability (TPR | Anaphylaxis)
{
    (0) : 0.98000000, 0.01000000, 0.01000000;
    (1) : 0.30000000, 0.40000000, 0.30000000;
}

probability (Hypovolemia)
{
    0.20000000, 0.80000000;
}

probability (LVFailure)
{
    0.05000000, 0.95000000;
}

probability (StrokeVolume | Hypovolemia, LVFailure)
{
    (0, 0) : 0.98000000, 0.01000000, 0.01000000;
    (0, 1) : 0.95000000, 0.04000000, 0.01000000;
    (1, 0) : 0.50000000, 0.49000000, 0.01000000;
    (1, 1) : 0.05000000, 0.90000000, 0.05000000;
}

probability (InsuffAnesth)
{
    0.20000000, 0.80000000;
}

probability (PulmEmbolus)
{
    0.01000000, 0.99000000;
}

probability (Shunt | PulmEmbolus, Intubation)
{
    (0, 0) : 0.10000000, 0.90000000;
    (0, 1) : 0.10000000, 0.90000000;
    (0, 2) : 0.01000000, 0.99000000;
    (1, 0) : 0.95000000, 0.05000000;
    (1, 1) : 0.95000000, 0.05000000;
    (1, 2) : 0.05000000, 0.95000000;
}

probability (FiO2)
{
    0.01000000, 0.99000000;
}

probability (PVSat | FiO2, VentAlv)
{
    (0, 0) : 0.98000000, 0.01000000, 0.01000000;
    (0, 1) : 0.98000000, 0.01000000, 0.01000000;
    (0, 2) : 0.95000000, 0.04000000, 0.01000000;
    (0, 3) : 0.95000000, 0.04000000, 0.01000000;
    (1, 0) : 0.98000000, 0.01000000, 0.01000000;
    (1, 1) : 0.98000000, 0.01000000, 0.01000000;
    (1, 2) : 0.01000000, 0.95000000, 0.04000000;
    (1, 3) : 0.01000000, 0.01000000, 0.98000000;
}

probability (SaO2 | Shunt, PVSat)
{
    (0, 0) : 0.98000000, 0.01000000, 0.01000000;
    (0, 1) : 0.01000000, 0.98000000, 0.01000000;
    (0, 2) : 0.01000000, 0.01000000, 0.98000000;
    (1, 0) : 0.98000000, 0.01000000, 0.01000000;
    (1, 1) : 0.98000000, 0.01000000, 0.01000000;
    (1, 2) : 0.69000000, 0.30000000, 0.01000000;
}

probability (Catechol | InsuffAnesth, SaO2, TPR, ArtCO2)
{
    (0, 0, 0, 0) : 0.01000000, 0.99000000;
    (0, 0, 0, 1) : 0.01000000, 0.99000000;
    (0, 0, 0, 2) : 0.01000000, 0.99000000;
    (0, 0, 1, 0) : 0.01000000, 0.99000000;
    (0, 0, 1, 1) : 0.01000000, 0.99000000;
    (0, 0, 1, 2) : 0.01000000, 0.99000000;
    (0, 0, 2, 0) : 0.01000000, 0.99000000;
    (0, 0, 2, 1) : 0.01000000, 0.99000000;
    (0, 0, 2, 2) : 0.01000000, 0.99000000;
    (0, 1, 0, 0) : 0.01000000, 0.99000000;
    (0, 1, 0, 1) : 0.01000000, 0.99000000;
    (0, 1, 0, 2) : 0.01000000, 0.99000000;
    (0, 1, 1, 0) : 0.01000000, 0.99000000;
    (0, 1, 1, 1) : 0.01000000, 0.99000000;
    (0, 1, 1, 2) : 0.01000000, 0.99000000;
    (0, 1, 2, 0) : 0.05000000, 0.95000000;
    (0, 1, 2, 1) : 0.05000000, 0.95000000;
    (0, 1, 2, 2) : 0.01000000, 0.99000000;
    (0, 2, 0, 0) : 0.01000000, 0.99000000;
    (0, 2, 0, 1) : 0.01000000, 0.99000000;
    (0, 2, 0, 2) : 0.01000000, 0.99000000;
    (0, 2, 1, 0) : 0.05000000, 0.95000000;
    (0, 2, 1, 1) : 0.05000000, 0.95000000;
    (0, 2, 1, 2) : 0.01000000, 0.99000000;
    (0, 2, 2, 0) : 0.05000000, 0.95000000;
    (0, 2, 2, 1) : 0.05000000, 0.95000000;
    (0, 2, 2, 2) : 0.01000000, 0.99000000;
    (1, 0, 0, 0) : 0.05000000, 0.95000000;
    (1, 0, 0, 1) : 0.05000000, 0.95000000;
    (1, 0, 0, 2) : 0.01000000, 0.99000000;
    (1, 0, 1, 0) : 0.05000000, 0.95000000;
    (1, 0, 1, 1) : 0.05000000, 0.95000000;
    (1, 0, 1, 2) : 0.01000000, 0.99000000;
    (1, 0, 2, 0) : 0.05000000, 0.95000000;
    (1, 0, 2, 1) : 0.05000000, 0.95000000;
    (1, 0, 2, 2) : 0.01000000, 0.99000000;
    (1, 1, 0, 0) : 0.10000000, 0.90000000;
    (1, 1, 0, 1) : 0.10000000, 0.90000000;
    (1, 1, 0, 2) : 0.10000000, 0.90000000;
    (1, 1, 1, 0) : 0.95000000, 0.05000000;
    (1, 1, 1, 1) : 0.95000000, 0.05000000;
    (1, 1, 1, 2) : 0.30000000, 0.70000000;
    (1, 1, 2, 0) : 0.95000000, 0.05000000;
    (1, 1, 2, 1) : 0.95000000, 0.05000000;
    (1, 1, 2, 2) : 0.30000000, 0.70000000;
    (1, 2, 0, 0) : 0.95000000, 0.05000000;
    (1, 2, 0, 1) : 0.95000000, 0.05000000;
    (1, 2, 0, 2) : 0.30000000, 0.70000000;
    (1, 2, 1, 0) : 0.99000000, 0.01000000;
    (1, 2, 1, 1) : 0.99000000, 0.01000000;
    (1, 2, 1, 2) : 0.99000000, 0.01000000;
    (1, 2, 2, 0) : 0.95000000, 0.05000000;
    (1, 2, 2, 1) : 0.99000000, 0.01000000;
    (1, 2, 2, 2) : 0.30000000, 0.70000000;
}

probability (HR | Catechol)
{
    (0) : 0.10000000, 0.89000000, 0.01000000;
    (1) : 0.01000000, 0.09000000, 0.90000000;
}

probability (CO | StrokeVolume, HR)
{
    (0, 0) : 0.98000000, 0.01000000, 0.01000000;
    (0, 1) : 0.95000000, 0.04000000, 0.01000000;
    (0, 2) : 0.80000000, 0.19000000, 0.01000000;
    (1, 0) : 0.95000000, 0.04000000, 0.01000000;
    (1, 1) : 0.04000000, 0.95000000, 0.01000000;
    (1, 2) : 0.01000000, 0.04000000, 0.95000000;
    (2, 0) : 0.30000000, 0.69000000, 0.01000000;
    (2, 1) : 0.01000000, 0.30000000, 0.69000000;
    (2, 2) : 0.01000000, 0.01000000, 0.98000000;
}

probability (BP | TPR, CO)
{
    (0, 0) : 0.98000000, 0.01000000, 0.01000000;
    (0, 1) : 0.98000000, 0.01000000, 0.01000000;
    (0, 2) : 0.90000000, 0.09000000, 0.01000000;
    (1, 0) : 0.98000000, 0.01000000, 0.01000000;
    (1, 1) : 0.10000000, 0.85000000, 0.05000000;
    (1, 2) : 0.05000000, 0.20000000, 0.75000000;
    (2, 0) : 0.30000000, 0.60000000, 0.10000000;
    (2, 1) : 0.05000000, 0.40000000, 0.55000000;
    (2, 2) : 0.01000000, 0.09000000, 0.90000000;
}

probability (LVEDVolume | Hypovolemia, LVFailure)
{
    (0, 0) : 0.95000000, 0.04000000, 0.01000000;
    (0, 1) : 0.98000000, 0.01000000, 0.01000000;
    (1, 0) : 0.01000000, 0.09000000, 0.90000000;
    (1, 1) : 0.05000000, 0.90000000, 0.05000000;
}

probability (CVP | LVEDVolume)
{
    (0) : 0.95000000, 0.04000000, 0.01000000;
    (1) : 0.04000000, 0.95000000, 0.01000000;
    (2) : 0.01000000, 0.29000000, 0.70000000;
}

probability (ErrCauter)
{
    0.10000000, 0.90000000;
}

probability (ErrLowOutput)
{
    0.05000000, 0.95000000;
}

probability (ExpCO2 | ArtCO2, VentLung)
{
    (0, 0) : 0.97000000, 0.01000000, 0.01000000, 0.01000000;
    (0, 1) : 0.01000000, 0.97000000, 0.01000000, 0.01000000;
    (0, 2) : 0.01000000, 0.97000000, 0.01000000, 0.01000000;
    (0, 3) : 0.01000000, 0.97000000, 0.01000000, 0.01000000;
    (1, 0) : 0.97000000, 0.01000000, 0.01000000, 0.01000000;
    (1, 1) : 0.01000000, 0.01000000, 0.97000000, 0.01000000;
    (1, 2) : 0.01000000, 0.01000000, 0.97000000, 0.01000000;
    (1, 3) : 0.01000000, 0.01000000, 0.97000000, 0.01000000;
    (2, 0) : 0.97000000, 0.01000000, 0.01000000, 0.01000000;
    (2, 1) : 0.01000000, 0.01000000, 0.01000000, 0.97000000;
    (2, 2) : 0.01000000, 0.01000000, 0.01000000, 0.97000000;
    (2, 3) : 0.01000000, 0.01000000, 0.01000000, 0.97000000;
}

probability (HRBP | ErrLowOutput, HR)
{
    (0, 0) : 0.98000000, 0.01000000, 0.01000000;
    (0, 1) : 0.40000000, 0.59000000, 0.01000000;
    (0, 2) : 0.30000000, 0.40000000, 0.30000000;
    (1, 0) : 0.98000000, 0.01000000, 0.01000000;
    (1, 1) : 0.01000000, 0.98000000, 0.01000000;
    (1, 2) : 0.01000000, 0.01000000, 0.98000000;
}

probability (HREKG | ErrCauter, HR)
{
    (0, 0) : 0.33333300, 0.33333300, 0.33333300;
    (0, 1) : 0.33333300, 0.33333300, 0.33333300;
    (0, 2) : 0.33333300, 0.33333300, 0.33333300;
    (1, 0) : 0.98000000, 0.01000000, 0.01000000;
    (1, 1) : 0.01000000, 0.98000000, 0.01000000;
    (1, 2) : 0.01000000, 0.01000000, 0.98000000;
}

probability (HRSat | ErrCauter, HR)
{
    (0, 0) : 0.33333300, 0.33333300, 0.33333300;
    (0, 1) : 0.33333300, 0.33333300, 0.33333300;
    (0, 2) : 0.33333300, 0.33333300, 0.33333300;
    (1, 0) : 0.98000000, 0.01000000, 0.01000000;
    (1, 1) : 0.01000000, 0.98000000, 0.01000000;
    (1, 2) : 0.01000000, 0.01000000, 0.98000000;
}

probability (History | LVFailure)
{
    (0) : 0.90000000, 0.10000000;
    (1) : 0.01000000, 0.99000000;
}

probability (MinVol | Intubation, VentLung)
{
    (0, 0) : 0.97000000, 0.01000000, 0.01000000, 0.01000000;
    (0, 1) : 0.01000000, 0.97000000, 0.01000000, 0.01000000;
    (0, 2) : 0.01000000, 0.01000000, 0.97000000, 0.01000000;
    (0, 3) : 0.01000000, 0.01000000, 0.01000000, 0.97000000;
    (1, 0) : 0.97000000, 0.01000000, 0.01000000, 0.01000000;
    (1, 1) : 0.60000000, 0.38000000, 0.01000000, 0.01000000;
    (1, 2) : 0.50000000, 0.48000000, 0.01000000, 0.01000000;
    (1, 3) : 0.50000000, 0.48000000, 0.01000000, 0.01000000;
    (2, 0) : 0.97000000, 0.01000000, 0.01000000, 0.01000000;
    (2, 1) : 0.01000000, 0.97000000, 0.01000000, 0.01000000;
    (2, 2) : 0.01000000, 0.01000000, 0.97000000, 0.01000000;
    (2, 3) : 0.01000000, 0.01000000, 0.01000000, 0.97000000;
}

probability (PAP | PulmEmbolus)
{
    (0) : 0.01000000, 0.19000000, 0.80000000;
    (1) : 0.05000000, 0.90000000, 0.05000000;
}

probability (PCWP | LVEDVolume)
{
    (0) : 0.95000000, 0.04000000, 0.01000000;
    (1) : 0.04000000, 0.95000000, 0.01000000;
    (2) : 0.01000000, 0.04000000, 0.95000000;
}

probability (Press | KinkedTube, Intubation, VentTube)
{
    (0, 0, 0) : 0.97000000, 0.01000000, 0.01000000, 0.01000000;
    (0, 0, 1) : 0.01000000, 0.49000000, 0.30000000, 0.20000000;
    (0, 0, 2) : 0.01000000, 0.01000000, 0.08000000, 0.90000000;
    (0, 0, 3) : 0.01000000, 0.01000000, 0.01000000, 0.97000000;
    (0, 1, 0) : 0.97000000, 0.01000000, 0.01000000, 0.01000000;
    (0, 1, 1) : 0.10000000, 0.84000000, 0.05000000, 0.01000000;
    (0, 1, 2) : 0.05000000, 0.25000000, 0.25000000, 0.45000000;
    (0, 1, 3) : 0.01000000, 0.15000000, 0.25000000, 0.59000000;
    (0, 2, 0) : 0.97000000, 0.01000000, 0.01000000, 0.01000000;
    (0, 2, 1) : 0.01000000, 0.29000000, 0.30000000, 0.40000000;
    (0, 2, 2) : 0.01000000, 0.01000000, 0.08000000, 0.90000000;
    (0, 2, 3) : 0.01000000, 0.01000000, 0.01000000, 0.97000000;
    (1, 0, 0) : 0.97000000, 0.01000000, 0.01000000, 0.01000000;
    (1, 0, 1) : 0.01000000, 0.97000000, 0.01000000, 0.01000000;
    (1, 0, 2) : 0.01000000, 0.01000000, 0.97000000, 0.01000000;
    (1, 0, 3) : 0.01000000, 0.01000000, 0.01000000, 0.97000000;
    (1, 1, 0) : 0.97000000, 0.01000000, 0.01000000, 0.01000000;
    (1, 1, 1) : 0.40000000, 0.58000000, 0.01000000, 0.01000000;
    (1, 1, 2) : 0.20000000, 0.75000000, 0.04000000, 0.01000000;
    (1, 1, 3) : 0.20000000, 0.70000000, 0.09000000, 0.01000000;
    (1, 2, 0) : 0.97000000, 0.01000000, 0.01000000, 0.01000000;
    (1, 2, 1) : 0.01000000, 0.90000000, 0.08000000, 0.01000000;
    (1, 2, 2) : 0.01000000, 0.01000000, 0.38000000, 0.60000000;
    (1, 2, 3) : 0.01000000, 0.01000000, 0.01000000, 0.97000000;
}
