package cve;
import java.io.*;
import ve.*;

/** a simple tester to extract rules from a BeliefNetwork.
 **/
public class TesterFromVE {
    static double accept_threshold = 0.51; // 0.8; // 0.99;
    public static void main(String[] args) {
	BeliefNetwork bn = new BeliefNetwork(readFile("examples/water.bn"),100);
//  	bn.print();

	RuleCollection rules = new RuleCollectionFromBeliefNetwork(bn,0.0,accept_threshold);


//   	rules.print();


//  	Variable[] exp = {bn.getVariables()[0],bn.getVariables()[1],bn.getVariables()[2],bn.getVariables()[3],bn.getVariables()[4],bn.getVariables()[5]};
//  	Factor expFactor = new FactorExpand(bn.getProbFactors()[5],exp);
//  	System.out.println("\nExpanded factor:");
//  	expFactor.print();
//  	for (int i=0; i<bn.getNumVariables(); i++) {
//  	    System.out.println("\n isRedundant "+i+":"+ expFactor.isRedundant(bn.getVariables()[i]));
//  	}
    }

    private static boolean factorEq(Factor f1,Factor f2) {
	EltsIterator I1 = f1.iterator();
	EltsIterator I2 = f2.iterator();
	while (I1.hasNext() && I2.hasNext()) {
	    if (I1.next() != I2.next()) {
		return false;}
	}
	return I1.hasNext()==I2.hasNext();
    }

    private static String readFile(String fileName) {
	try {
	    BufferedReader in =  new BufferedReader( new FileReader( fileName ) );
	    String line;
	    String all = "";

	    line = in.readLine();
	    while( line != null )
		{
		    all += line + "\n";
		    line = in.readLine();
		}
	    in.close();
	    return all;
	}
	catch( Exception e ) {
	    System.out.println( "Error: " + e.toString() );
	    return "";
	}
    }
}
