// java -verbose:gc  -Xmx460m -Xms256m -Xfuture cve/TesterCompare
// java -Xmx660m -Xms256m -Xfuture cve/TesterCompareBIF
// java -Xmx660m -Xms156m -Xfuture cve/TesterCompareBIF

package cve;
import java.io.*;
import ve.*;

public class TesterCompareBIF {

    static double accept_threshold = 0.51; // 0.8; // 0.99;
    public static void main(String[] args) {
	BifFile[] files = {
	    //	    "test",
 	    new BifFile("alarm",1), // 0=lexicographic 1=reverse
	    new BifFile("insurance",0),
	    new BifFile("hailfinder",0),
	    new BifFile("PigsNew",0),
       	    new BifFile("WaterNew",0),
	    //  new BifFile("LinkNew",0),
  	    new BifFile("Munin1New",0),
	    new BifFile("Munin2New",0),
	    new BifFile("Munin3New",0),
	    new BifFile("Munin4New",0),
	    new BifFile("BarleyNew",0),
	    new BifFile("MildewNew",0),
	    new BifFile("DiabetesNew",0)
	};
	System.out.println("Network & BN Size & Num Factors & Threshold & Accept_threshold & CBN Size & Num Rules & VE Max Factor & CVE Max Factor/NumRules/Consize\\\\");
	for (int i=0 ; i< files.length; i++) {
	    //System.out.print("\n*** new file ***");
	    DecisionNetwork orgbn;
	    try {
		orgbn = new DecisionNetworkFromBIFrevs(new BufferedReader( new FileReader("examples/"+ files[i].fileName+".bif" ) ),2000,files[i].ordering);
	    }
	    catch( Exception e ) {
		System.out.println( "Error: " + e.toString() + " (in "+files[i].fileName+").");
		return;
	    }
	    // orgbn.printBrief(); 
	    for (double threshold=0.0; threshold < .31; threshold += 0.05) {
		System.out.print(files[i].fileName+" & ");
		DecisionNetwork bn = new BeliefNetworkFromThreshold(orgbn,threshold);
		System.out.print(bn.getSize()+" &  "+bn.getNumProbFactors()+" &  ");
		System.out.print(threshold + " & ");
		System.out.print(accept_threshold + " & ");
		ContextualBeliefNetwork cbn = new ContextualBeliefNetwork(bn,threshold,accept_threshold);
		//   cbn.print();

		Variable[] observedVars = {};
		int[] observedVals = {};
		Variable[] queryVars = {bn.getVariables()[bn.getNumVariables()/2]};

		//	System.out.println(fileName);
		System.out.print(cbn.getRules().getSize()+" & "+cbn.getRules().getNumRules());
		Variable[] eo;
		int veMaxSize;
		{
		    QueryPretend eoquery = new QueryPretend(queryVars,bn,observedVars,observedVals,"minfac");
		    veMaxSize = eoquery.getMaxFactorSize();
		    System.out.print(" & "+veMaxSize);
		    eo = eoquery.getEO();
		}
		RuleCollection.resetMaxTableSize();
		CVEQueryPretend cveans = new CVEQueryPretend(queryVars,cbn,observedVars,observedVals,eo);
		int cveMaxTable= cveans.getResult().getMaxTableSize();
		System.out.print(" & "+cveMaxTable+"/"+cveans.getResult().getMaxNumRules()+"/"+cveans.getResult().getMaxContextSize());
		System.out.println("\\\\");
	    }
	}
	//Variable[] eo;
//  	{
//  	Query eoquery = new Query(queryVars,bn,observedVars,observedVals,"minfac");
//  	eo = eoquery.getEO();
//  	}
//  	// Time CVE
//  	long cveTime=Long.MAX_VALUE;
//  	int cveMaxTable=0;
//  	for (int i=0; i<3; i++) {
//  	    long prequeryTime = System.currentTimeMillis();
//  	    CVEQuery cveans = new CVEQuery(queryVars,cbn,observedVars,observedVals,eo);
//  	    long postqueryTime = System.currentTimeMillis();
//  	    //  	System.out.println("\n***Result from CVEQuery");
//  	    //  	cveans.getResult().print();
//  	    //  	System.out.println("Time: "+(postqueryTime0-prequeryTime0)+" - "+(postqueryTime-prequeryTime)+" msecs.");
//  	    cveMaxTable= cveans.getResult().getMaxTableSize();
//  	    //  	System.out.println("Max Table Size: "+cveMaxTable);    
//  	    cveTime = Math.min(cveTime,(postqueryTime-prequeryTime));
//  	    RuleCollection.resetMaxTableSize();
//  	}
//  	System.out.print( cveTime +" & "+ cveMaxTable +" & ");
//  	// Time VE
//  	long veTime=Long.MAX_VALUE;
//  	int veMaxSize=0;
//  	for (int i=0; i<3; i++) {
//  //  	System.out.println("redoing");
//  	    long veprequeryTime = System.currentTimeMillis();
//  	    Query veans =new Query(queryVars,bn,observedVars,observedVals,eo);
//  	    long vepostqueryTime = System.currentTimeMillis();
//  //  	System.out.println("\n***Result from VE Query");
//  //  	veans.getUnNormResult().print();
//  //  	System.out.println("Time: "+(vepostqueryTime0-veprequeryTime0)+" - "+ (vepostqueryTime-veprequeryTime)+" msecs.");
//  	    veMaxSize = veans.getMaxFactorSize();
//  //  	System.out.println("Max Factor Size: "+veMaxSize);  
//  	    veTime = Math.min(veTime,(vepostqueryTime-veprequeryTime));
//  	}
//  	// NumVars & NumSplits & ProbInFactor & CBN Size & BN Size 
//  	//   & CVE time & CVE Max Table & VE Time & VE MaxFactor
//  	System.out.println( veTime +" & "+veMaxSize+" \\\\");
//  	}}
//      }
    }

    private static String readFile(String fileName) {
	try {
	    BufferedReader in =  new BufferedReader( new FileReader( fileName ) );
	    String line;
	    String all = "";

	    line = in.readLine();
	    while( line != null ) {
		    all += line + "\n";
		    line = in.readLine();
		}
	    in.close();
	    return all;
	}
	catch( Exception e ) {
	    System.out.println( "Error: " + e.toString() );
	    return "";
	}
    }
}
