// java -verbose:gc  -Xmx460m -Xms256m -Xfuture cve/TesterCompare
// java -Xmx660m -Xms256m -Xfuture cve/TesterCompare
// java -Xmx660m -Xms156m -Xfuture cve/TesterCompare

package cve;
import java.io.*;
import ve.*;

/** the class that carries out comparisons on random graphs.
 **/
public class TesterCompare {
    private static final int NUMVARS = 30;
    //private static final int NUMSPLITS = 35;
    private static final double PROBINFACTOR = 0.2;
    private static final double PROBSHARED = 1.0/9.0;

    public static void main(String[] args) {
	System.out.println("# Vars & # Splits (# Split Vars) & Prob in Factor & CBN Size & BN Size & CVE Time & CVE Max Table Size & VE Time & VE max table size\\\\");
	for (int NUMSPLITS=5; NUMSPLITS <51; NUMSPLITS+=5) {
	for (int numIterations=0; numIterations<10; numIterations++) {{
	// Construct the networks
	ContextualBeliefNetwork cbn = 
	    //new ContextualBeliefNetworkRandom2(NUMVARS,NUMSPLITS,PROBINFACTOR,PROBSHARED);
	    new ContextualBeliefNetworkRandom(NUMVARS,NUMSPLITS,PROBINFACTOR);
	//new ContextualBeliefNetworkRandom3(NUMVARS,NUMSPLITS,PROBINFACTOR);
//  	cbn.printBrief();
	BeliefNetwork bn = new BeliefNetFromCBN(cbn);
//  	bn.printBrief();
	System.out.print(NUMVARS+" & "+NUMSPLITS+" ("+cbn.getNumSplitVars()+") & "+PROBINFACTOR+" & "+cbn.getRules().getSize()+" & "+bn.getSize()+" & ");
	Variable[] observedVars = {}; //{bn.getVariables()[6]};
	int[] observedVals = {}; //{0};
  	Variable[] queryVars = {bn.getVariables()[NUMVARS/2]};
	Variable[] eo;
	{
	Query eoquery = new Query(queryVars,bn,observedVars,observedVals,"minfac");
	eo = eoquery.getEO();
	}
	// Time CVE
	long cveTime=Long.MAX_VALUE;
	int cveMaxTable=0;
	for (int i=0; i<3; i++) {
	    long prequeryTime = System.currentTimeMillis();
	    CVEQuery cveans = new CVEQuery(queryVars,cbn,observedVars,observedVals,eo);
	    long postqueryTime = System.currentTimeMillis();
	    //  	System.out.println("\n***Result from CVEQuery");
	    //  	cveans.getResult().print();
	    //  	System.out.println("Time: "+(postqueryTime0-prequeryTime0)+" - "+(postqueryTime-prequeryTime)+" msecs.");
	    cveMaxTable= cveans.getResult().getMaxTableSize();
	    //  	System.out.println("Max Table Size: "+cveMaxTable);    
	    cveTime = Math.min(cveTime,(postqueryTime-prequeryTime));
	    RuleCollection.resetMaxTableSize();
	}
	System.out.print( cveTime +" & "+ cveMaxTable +" & ");
	// Time VE
	long veTime=Long.MAX_VALUE;
	int veMaxSize=0;
	for (int i=0; i<3; i++) {
//  	System.out.println("redoing");
	    long veprequeryTime = System.currentTimeMillis();
	    Query veans =new Query(queryVars,bn,observedVars,observedVals,eo);
	    long vepostqueryTime = System.currentTimeMillis();
//  	System.out.println("\n***Result from VE Query");
//  	veans.getUnNormResult().print();
//  	System.out.println("Time: "+(vepostqueryTime0-veprequeryTime0)+" - "+ (vepostqueryTime-veprequeryTime)+" msecs.");
	    veMaxSize = veans.getMaxFactorSize();
//  	System.out.println("Max Factor Size: "+veMaxSize);  
	    veTime = Math.min(veTime,(vepostqueryTime-veprequeryTime));
	}
	// NumVars & NumSplits & ProbInFactor & CBN Size & BN Size 
	//   & CVE time & CVE Max Table & VE Time & VE MaxFactor
	System.out.println( veTime +" & "+veMaxSize+" \\\\");
	}}
    }
    }

    private static String readFile(String fileName) {
	try {
	    BufferedReader in =  new BufferedReader( new FileReader( fileName ) );
	    String line;
	    String all = "";

	    line = in.readLine();
	    while( line != null ) {
		    all += line + "\n";
		    line = in.readLine();
		}
	    in.close();
	    return all;
	}
	catch( Exception e ) {
	    System.out.println( "Error: " + e.toString() );
	    return "";
	}
    }
}
