// java -verbose:gc  -Xmx460m -Xms256m -Xfuture cve/TesterCompare
// java -Xmx660m -Xms256m -Xfuture cve/TesterBIFeo
// java  -Xmx128m cve/TesterBIF
// java -Xmx660m -Xms156m -Xfuture cve/TesterCompareBIF

package cve;
import java.io.*;
import ve.*;
/** The class that tests the details of the runtimes for BIF files.
 **/
public class TesterBIFeo {

    public static void main(String[] args) {
	    double threshold=0.05; // 0.05;
	    double accept_threshold = 0.99999; // 0.501; // 0.8; 
	    Query.checkOnes=false;
	    RuleCollection.checkOnes=false;

	BifFile[] files = {
	    //	    "test",
 	    //new BifFile("alarm",1), // 0=lexicographic 1=reverse
	    //new BifFile("insurance",0),
	    //new BifFile("hailfinder",0),
	    //new BifFile("PigsNew",0),
       	    new BifFile("WaterNew",0),
	    //  new BifFile("LinkNew",0),
  	    //new BifFile("Munin1New",0),
	    //new BifFile("Munin2New",0),
	    //new BifFile("Munin3New",0),
	    //new BifFile("Munin4New",0),
	    //new BifFile("BarleyNew",0),
	    //new BifFile("MildewNew",0),
	    //new BifFile("DiabetesNew",0)
	};
	for (int i=0 ; i< files.length; i++) {
	    //System.out.print("\n*** new file ***");
	    DecisionNetwork orgbn;
	    try {
		orgbn = new DecisionNetworkFromBIFrevs(new BufferedReader( new FileReader("examples/"+ files[i].fileName+".bif" ) ),2000,files[i].ordering);
	    }
	    catch( Exception e ) {
		System.out.println( "Error: " + e.toString() + " (in "+files[i].fileName+").");
		return;
	    }
	    // orgbn.printBrief(); 
	    System.out.println("File: "+files[i].fileName);
	    System.out.println("Threshold: "+threshold);
	    System.out.println("Accept Threshold: "+accept_threshold);
	    DecisionNetwork bn = new BeliefNetworkFromThreshold(orgbn,threshold);
	    System.out.println("Number of variables: "+bn.getNumProbFactors());
	    System.out.println("Belief networks total size: "+bn.getSize());

	    ContextualBeliefNetwork cbn = new ContextualBeliefNetwork(bn,threshold,accept_threshold);
	    System.out.println("CBN total size: "+cbn.getRules().getSize()+" Number of rules "+cbn.getRules().getNumRules());
	    //   cbn.print();
	    System.out.println("Numobs & Observed & Query Var & CVE Time & CVE Max Factor & VETime & veMaxFactor\\\\");

	    int numobs=0;
	    int retries=1;
	    Variable[] observedVars = {};
	    int[] observedVals = {};

	    System.out.print(" & ");

	    Variable[] queryVars = {(Variable) orgbn.getStringToVar().get("CKNN_12_15")};
	    System.out.print(queryVars[0].getName()+") & ");
	    //	System.out.println(fileName);
	    Variable[] eo= new Variable[31];

	    String[] eostring={"C_NI_12_45", "CKNI_12_45", "CBODD_12_45", "CKND_12_45", "CNOD_12_45", "CBODN_12_45", "CKNN_12_45", "CNON_12_45", "CKND_12_00", "CKND_12_30", "CKND_12_15", "C_NI_12_30", "C_NI_12_00", "CKNN_12_30", "CNON_12_00", "CKNI_12_30", "CNOD_12_00", "CBODD_12_00", "CBODN_12_00", "CBODD_12_15", "CNOD_12_30", "CBODN_12_30", "CBODN_12_15", "CNON_12_30", "CNOD_12_15", "CKNI_12_00", "CNON_12_15", "C_NI_12_15", "CKNI_12_15", "CBODD_12_30", "CKNN_12_00", "CKNN_12_15"};

	    for (int j=0; j<31; j++) {
		eo[j]=(Variable) orgbn.getStringToVar().get(eostring[j]);
	    }
	    int veMaxSize;
	    RuleCollection.resetMaxTableSize();
	    //  		CVEQueryPretend cveans = new CVEQueryPretend(queryVars,cbn,observedVars,observedVals,eo);
	    //  		int cveMaxTable= cveans.getResult().getMaxTableSize();
	    //System.out.print(" & "+cveMaxTable+"/"+cveans.getResult().getMaxNumRules()+"/"+cveans.getResult().getMaxContextSize());
	    //System.out.println("\\\\");

	    // Time CVE
	    {
	    long cveTime=Long.MAX_VALUE;
	    int cveMaxTable=0;
	    long prequeryTime = System.currentTimeMillis();
	    CVEQuery cveans = new CVEQuery(queryVars,cbn,observedVars,observedVals,eo);
	    long postqueryTime = System.currentTimeMillis();
	      	System.out.println("\n***Result from CVEQuery");
	     	cveans.getResult().print();
	    //  	System.out.println("Time: "+(postqueryTime0-prequeryTime0)+" - "+(postqueryTime-prequeryTime)+" msecs.");
	    cveMaxTable= cveans.getResult().getMaxTableSize();
	    //  	System.out.println("Max Table Size: "+cveMaxTable);    
	    cveTime = Math.min(cveTime,(postqueryTime-prequeryTime));
	    RuleCollection.resetMaxTableSize();

	    System.out.print( " CVE: "+ cveTime +" & "+ cveMaxTable +" & ");
	    }
	    // Time VE
	    long veTime=Long.MAX_VALUE;
	    //	int veMaxSize=0;

	    //System.out.println("redoing");
	    long veprequeryTime = System.currentTimeMillis();
	    Query veans =new Query(queryVars,bn,observedVars,observedVals,eo);
	    long vepostqueryTime = System.currentTimeMillis();
//  	System.out.println("Time: "+(vepostqueryTime0-veprequeryTime0)+" - "+ (vepostqueryTime-veprequeryTime)+" msecs.");
	    veMaxSize = veans.getMaxFactorSize();
	    //  	System.out.println("Max Factor Size: "+veMaxSize);  
	    veTime = Math.min(veTime,(vepostqueryTime-veprequeryTime));

	    // NumVars & NumSplits & ProbInFactor & CBN Size & BN Size 
	    //   & CVE time & CVE Max Table & VE Time & VE MaxFactor
	    System.out.println( " VE: "+veTime +" & "+veMaxSize+" \\\\");
     	     	System.out.println("\n***Result from VE Query");
	     	veans.getUnNormResult().print();
  
	}
    }

    private static String readFile(String fileName) {
	try {
	    BufferedReader in =  new BufferedReader( new FileReader( fileName ) );
	    String line;
	    String all = "";

	    line = in.readLine();
	    while( line != null ) {
		all += line + "\n";
		line = in.readLine();
	    }
	    in.close();
	    return all;
	}
	catch( Exception e ) {
	    System.out.println( "Error: " + e.toString() );
	    return "";
	}
    }
}
