// java -verbose:gc  -Xmx460m -Xms256m -Xfuture cve/TesterCompare
// java -Xmx660m -Xms256m -Xfuture cve/TesterBIF
// java  -Xmx128m cve/TesterBIF
// java -Xmx660m -Xms156m -Xfuture cve/TesterCompareBIF

package cve;
import java.io.*;
import ve.*;
/** The class that tests runtimes for BIF files.
 **/
public class TesterBIF {

    public static void main(String[] args) {
	    double threshold=0.05;
	    double accept_threshold=0.501; // 0.8;  //  0.9999;
//  	    Query.checkOnes=false;
//  	    RuleCollection.checkOnes=false;

	BifFile[] files = {
	    //	    "test",
 	    //new BifFile("alarm",1), // 0=lexicographic 1=reverse
	    //new BifFile("insurance",0),
	    //new BifFile("hailfinder",0),
	    //new BifFile("PigsNew",0),
       	    new BifFile("WaterNew",0),
	    //  new BifFile("LinkNew",0),
  	    //new BifFile("Munin1New",0),
	    //new BifFile("Munin2New",0),
	    //new BifFile("Munin3New",0),
	    //new BifFile("Munin4New",0),
	    //new BifFile("BarleyNew",0),
	    //new BifFile("MildewNew",0),
	    //new BifFile("DiabetesNew",0)
	};
	for (int i=0 ; i< files.length; i++) {
	    //System.out.print("\n*** new file ***");
	    DecisionNetwork orgbn;
	    try {
		orgbn = new DecisionNetworkFromBIFrevs(new BufferedReader( new FileReader("examples/"+ files[i].fileName+".bif" ) ),2000,files[i].ordering);
	    }
	    catch( Exception e ) {
		System.out.println( "Error: " + e.toString() + " (in "+files[i].fileName+").");
		return;
	    }
	    // orgbn.printBrief(); 
		System.out.println("File: "+files[i].fileName);
		System.out.println("Threshold: "+threshold);
		System.out.println("Accept Threshold: "+accept_threshold);
		DecisionNetwork bn = new BeliefNetworkFromThreshold(orgbn,threshold);
		System.out.println("Number of variables: "+bn.getNumProbFactors());
		System.out.println("Belief networks total size: "+bn.getSize());

		ContextualBeliefNetwork cbn = new ContextualBeliefNetwork(bn,threshold,accept_threshold);
		System.out.println("CBN total size: "+cbn.getRules().getSize()+" Number of rules "+cbn.getRules().getNumRules());
		//   cbn.print();
	System.out.println("Numobs & Observed & Query Var & CVE Time & CVE Max Factor & VETime & veMaxFactor\\\\");

	    for (int numobs=0; numobs<=10; numobs+=5) {
		for (int retries=10; retries>0; retries--) {
		    System.out.print(numobs+" & ");
		Variable[] observedVars = new Variable[numobs];
		int[] observedVals = new int[numobs];

                // COnstruct the random observations
		int[] obspos = new int[numobs];  // positions of the obs
		int obsfound=0;
		while (obsfound < numobs) {
		    int newobs = (int) (Math.random()*bn.getNumVariables());
		    // find its position
		    int newpos = obsfound;
		    while (newpos > 0 && newobs < obspos[newpos-1]) {
			newpos--;}
		    if (newpos == 0 || newobs != obspos[newpos-1]) {
			// we have found a new number
			// shuffle it into position
			for (int s=obsfound; s>newpos; s--) {
			    obspos[s]=obspos[s-1];
			}
			obspos[newpos]=newobs;
			obsfound++;
		    }
		}
		//System.out.print("Observed:");
		for (int j=0;j<numobs;j++) {
		    observedVars[j]=bn.getVariables()[obspos[j]];
		    observedVals[j]=(int) (Math.random()*observedVars[j].getDomain().length);
		    System.out.print(" #"+obspos[j]+"="+observedVals[j]);
		}
		boolean lookingForQuery=true;
		int queryIdx=0;
		while (lookingForQuery) {
		    queryIdx=(int) (Math.random()*bn.getNumVariables());
		    int newpos=numobs-1;
		    while (newpos>=0 && queryIdx < obspos[newpos]) {
			newpos--;
		    }
		    if (newpos <0 || queryIdx != obspos[newpos]) {
			lookingForQuery=false;
		    }
		}

		System.out.print(" & #"+
				 queryIdx+"(");

		Variable[] queryVars = {bn.getVariables()[queryIdx]};
		System.out.print(queryVars[0].getName()+") & ");
		//	System.out.println(fileName);
		Variable[] eo;
		int veMaxSize;
		{
		    QueryPretend eoquery = new QueryPretend(queryVars,bn,observedVars,observedVals,"minfac");
		    veMaxSize = eoquery.getMaxFactorSize();
  		    System.out.print(veMaxSize+" & ");
		    eo = eoquery.getEO();
		}
		RuleCollection.resetMaxTableSize();
//  		CVEQueryPretend cveans = new CVEQueryPretend(queryVars,cbn,observedVars,observedVals,eo);
//  		int cveMaxTable= cveans.getResult().getMaxTableSize();
		//System.out.print(" & "+cveMaxTable+"/"+cveans.getResult().getMaxNumRules()+"/"+cveans.getResult().getMaxContextSize());
		//System.out.println("\\\\");

	// Time CVE
	long cveTime=Long.MAX_VALUE;
	int cveMaxTable=0;
	for (int j=0; j<3; j++) {
	    long prequeryTime = System.currentTimeMillis();
	    CVEQuery cveans = new CVEQuery(queryVars,cbn,observedVars,observedVals,eo);
	    long postqueryTime = System.currentTimeMillis();
	    //  	System.out.println("\n***Result from CVEQuery");
	    //  	cveans.getResult().print();
	    //  	System.out.println("Time: "+(postqueryTime0-prequeryTime0)+" - "+(postqueryTime-prequeryTime)+" msecs.");
	    cveMaxTable= cveans.getResult().getMaxTableSize();
	    //  	System.out.println("Max Table Size: "+cveMaxTable);    
	    cveTime = Math.min(cveTime,(postqueryTime-prequeryTime));
	    RuleCollection.resetMaxTableSize();
	}
	System.out.print( " CVE: "+ cveTime +" & "+ cveMaxTable +" & ");
	// Time VE
	long veTime=Long.MAX_VALUE;
	//	int veMaxSize=0;
	for (int j=0; j<3; j++) {
	    //System.out.println("redoing");
	    long veprequeryTime = System.currentTimeMillis();
	    Query veans =new Query(queryVars,bn,observedVars,observedVals,eo);
	    long vepostqueryTime = System.currentTimeMillis();
	    //  	System.out.println("\n***Result from VE Query");
	    //  	veans.getUnNormResult().print();
	    //  	System.out.println("Time: "+(vepostqueryTime0-veprequeryTime0)+" - "+ (vepostqueryTime-veprequeryTime)+" msecs.");
	    veMaxSize = veans.getMaxFactorSize();
	    //  	System.out.println("Max Factor Size: "+veMaxSize);  
	    veTime = Math.min(veTime,(vepostqueryTime-veprequeryTime));
	}
	// NumVars & NumSplits & ProbInFactor & CBN Size & BN Size 
	//   & CVE time & CVE Max Table & VE Time & VE MaxFactor
	System.out.println( " VE: "+veTime +" & "+veMaxSize+" \\\\");
	}}
	}
    }

    private static String readFile(String fileName) {
	try {
	    BufferedReader in =  new BufferedReader( new FileReader( fileName ) );
	    String line;
	    String all = "";

	    line = in.readLine();
	    while( line != null ) {
		    all += line + "\n";
		    line = in.readLine();
		}
	    in.close();
	    return all;
	}
	catch( Exception e ) {
	    System.out.println( "Error: " + e.toString() );
	    return "";
	}
    }
}
