package cve;
import ve.*;

/**
 * This is a rule collection that we make by adding factors. It is
 * only a new class because I wanted it in another file ;^}
 *
 * @author David Poole
 * @version 0.1 2001-07-11
 **/

public class RuleCollectionFromEntropySplit extends RuleCollection {

    /**
     * construces a rule collection from a belief network.
     **/
    RuleCollectionFromEntropySplit(DecisionNetwork bn, double threshold) {
	super();
	int preSize=0;
	int postSize=0;
	for (int i=0; i< bn.getNumVariables(); i++) {
	    Variable[] factorFor = {bn.getVariables()[i]};
	    Factor currFactor = bn.getProbFactors()[i];
	    preSize+=currFactor.size();
	    addFactorToCollection(currFactor);
	}
    }

    private void addFactorToCollection(Factor newFac) {
	
    }

}
