package cve;
import ve.*;

/**
 * This is a rule collection that we make by adding factors. It is
 * only a new class because I wanted it in another file ;^}
 *
 * @author David Poole
 * @version 0.2 2001-11-06
 **/

public class RuleCollectionFromBeliefNetwork extends RuleCollection {

    private static final double ACCEPT_THRESHOLD= 0.51;// 0.9999;  // 0.8;

    /**
     * constructs a rule collection from a belief network.
     **/
    RuleCollectionFromBeliefNetwork(DecisionNetwork bn, double threshold, double accept_threshold) {
	super();
	int preSize=0;
	int postSize=0;
	for (int i=0; i< bn.getNumVariables(); i++) {
	    Variable[] factorFor = {bn.getVariables()[i]};
	    preSize+=bn.getProbFactors()[i].size();
	    int newSize=addRulesFromFactor(new Context(),
				  bn.getProbFactors()[i],
				  factorFor,
				  threshold,
				  accept_threshold);
	    postSize += newSize;
	}
    }

    RuleCollectionFromBeliefNetwork() {
	super();
    }

    /**
     *  adds a new factor (with a context) to the rule collection.
    **/
    private int addRulesFromFactor(Context con,Factor fac,Variable[] ruleIsFor, double threshold, double accept_threshold) {
	int factorSize = fac.getVariables().length;
	// remove redundant variables
	Variable[] redundantVars = new Variable[factorSize];
	int numRedundantVars=0;
	for (int j=0; j<factorSize; j++) {
	    if (fac.getVariables()[j] != ruleIsFor[0] &&
		fac.isRedundant(fac.getVariables()[j], threshold)) {
		redundantVars[numRedundantVars++]=fac.getVariables()[j];
	    }
	}
	if (numRedundantVars > 0) {
	    Variable[] reds = new Variable[numRedundantVars];
	    int[] vals = new int[numRedundantVars];
	    for (int j=0; j<numRedundantVars; j++) {
		reds[j]=redundantVars[j];
		vals[j]=0;
	    }
	    fac = new FactorObserved(fac, reds, vals);
	    factorSize = fac.getVariables().length;
	}

	if (factorSize == 1) {
	    add(new GenRule(con,fac,ruleIsFor));
	    return fac.size();
	}
	else {
	    // choose a variable to split on
	    int bestPos=0;
	    if (ruleIsFor[0]==fac.getVariables()[0]) {
		bestPos=1;
	    }
	    int bestGoodness = goodness(fac,fac.getVariables()[bestPos],ruleIsFor[0],threshold);
	    for (int pos=bestPos+1; pos < factorSize; pos++) {
		if (ruleIsFor[0]!=fac.getVariables()[pos]) {
		    int currGoodness = goodness(fac,fac.getVariables()[pos],ruleIsFor[0],threshold);
		    if (currGoodness > bestGoodness) {
			bestGoodness=currGoodness;
			bestPos=pos;
		    }
		}
	    }
	    // split on bestPos
	    RuleCollectionFromBeliefNetwork propRC = new RuleCollectionFromBeliefNetwork();
	    for (int i=0; 
		 i<fac.getVariables()[bestPos].getDomain().length;
		 i++) {
		propRC.addRulesFromFactor(
					  new Context(con,fac.getVariables()[bestPos],i),
					  new FactorAssign(fac,fac.getVariables()[bestPos],i),
					  ruleIsFor,
					  threshold,
					  accept_threshold);
	    }
		
	    // determine if we should accept the rules or the table
	    if (propRC.getSize() < accept_threshold * fac.size()) {
		this.add(propRC);
		return propRC.getSize();
	    }
	    else {
		this.add(new GenRule(con,fac,ruleIsFor));
		return fac.size();
	    }
	}
    }

    private int goodness(Factor fac, Variable var1, Variable var2, double threshold) {
	//System.out.print("Goodness for "+var1.getName()+" & "+var2.getName()+" in "+fac.getName());
	if (var2.getId() < var1.getId()) {
	    Variable temp = var1;
	    var1=var2;
	    var2=temp;
	}
	int count=0;
	Variable[] obs = {var1,var2};
	for (int i1=0; i1<var1.getDomain().length;i1++) {
	    for (int i2=0; i2<var2.getDomain().length;i2++) {
		int[] vals = {i1,i2};
		FactorObserved simpfac = new FactorObserved(fac,obs,vals);
		for (EltsIterator it1 = simpfac.iterator(); it1.hasNext();) {
		    double next1 = it1.next();
		    for (EltsIterator it2 = simpfac.iterator(); it2.hasNext();) {
			if (Math.abs(next1 - it2.next()) <= threshold) {
			    count++;
			}
		    }
		}
	    }
	}
	//System.out.println(" = "+count);
	return count;
    }

}
