package cve;
import java.io.*;
import ve.*;

/**
 * This the the class of factors that can be updated from generalised rules.
 *
 * @author David Poole
 * @version 0.1 2001-05-12
 **/
public class FactorUpdatable extends FactorStored {

    /**
     * constructs a factor with the given variables.
     *
     * @param vars the list of variables
     **/
    FactorUpdatable(Variable[] vars) {
	super(vars,BY_UPDATABLE);
	base = new int[vars.length];
	int curbase=1;
	//  	System.out.print("\nCreatung a factor on: [");
	for (int i=vars.length-1; i>=0; i--) {
	    base[i]=curbase;
	    curbase *= this.getVariables()[i].getDomain().length;
	    //	    System.out.print(" "+this.getVariables()[i].getName());
	}
	//System.out.println("]");
    }

    /**
     * updates every stored value corresponding to the rule. This must
     * also update all of the values.
     **/
    public void update(GenRule rule) {
//  	System.out.println("\n\nConverting Rule:");
//  	rule.print();
//  	System.out.println("Converted");
	EltsIterator ruleItr = rule.getFactor().iterator();
	updatefrom(rule,0,0,0,0,ruleItr);
    }

    /**
     * gives the number of elements to the right for each variable.
     **/
    private int[] base;

    /**
     * when updating by a rule, updatefrom iterates over the
     * variables in the current factor. For each variable it does
     * different things depending on whether the variable is in the
     * context, in the factor of the rule or isn't in the generalised
     * rule.

     * @param rule the rule to be updating from
     * @param conpos the current position in the context of the rule
     * @param facpos the current position in the variables of the rule
     * @param varpos the current position in the varibales of the 
     *   current factor
     * @param valpos the current position in the values of the current factor
     * @param ruleItr an iterator over the rule factor
     * @return the updated position in the current factor
     **/
    private void updatefrom(GenRule rule, int conpos, int facpos, int varpos, int valpos, EltsIterator ruleItr) {
	if (varpos >= this.getVariables().length) {
	    factorValues[valpos]=ruleItr.next();
	}
	else if (conpos < rule.getContext().getVars().length
		 && this.getVariables()[varpos] == rule.getContext().getVars()[conpos]) {
		 // variable is in the context
	    updatefrom(rule,conpos+1,facpos,varpos+1,valpos+rule.getContext().getVals()[conpos]*base[varpos],ruleItr);
	}
	else if (facpos < rule.getFactor().getVariables().length
		 && this.getVariables()[varpos] == rule.getFactor().getVariables()[facpos]) {
	    // variable is in the factor
	    for (int val=0; val<this.getVariables()[varpos].getDomain().length; val++) {
		updatefrom(rule,conpos,facpos+1,varpos+1,valpos+val*base[varpos],ruleItr);
	    }
	}
	else {
	    // variable isn't in the rule
	    int itrpos=ruleItr.currPos();
	    for (int val=0; val<this.getVariables()[varpos].getDomain().length; val++) {
		ruleItr.backTo(itrpos);
		updatefrom(rule,conpos,facpos,varpos+1,valpos+val*base[varpos],ruleItr);
	    }
	}
    }
}
