package cve;
import ve.*;

/**
 * A covering rule collection is a collection of generalised rules
 * that are disjoint and covering.
 *
 * @author David Poole
 * @version 0.1 2001-04-02 */

public class CoveringRuleCollection extends RuleCollection {
    
    /**
     * absorbs this generalised rule into a collection of generalised rules.
     *
     * @param genRules a collection of GenRule to absorb this rule into.
     * @param return a rule collection of GenRule to add the results to.
     */
    public CoveringRuleCollection absorb(GenRule rule) {
//  	System.out.println("\n\nAbsorbing:");
//  	rule.print();
//  	System.out.println("Into the CoveringRuleCollection:");
//  	this.print();
//  	System.out.println("\nEnd Absorbing\n\n\n\n");
	CoveringRuleCollection result= new CoveringRuleCollection();
	RuleIterator rulesItr = this.iterator();
	while (rulesItr.hasNext()) {
	    GenRule ri = rulesItr.next();
	    if (rule.getContext().compatible(ri.getContext())) {
		ri.addResiduals(rule.getContext(),result);
		result.add(new GenRule(rule.getContext().union(ri.getContext()),
				       new FactorTimes(factorSet(rule.getFactor(),ri.getContext()),
						       factorSet(ri.getFactor(),rule.getContext())),
				       unionVariableArrays(rule.getRulesFor(),
							   ri.getRulesFor())));
	    }
	    else {
		result.add(ri);
	    }
	}
//  	System.out.println("\n\nResult of absorbing:");
//  	result.print();
//  	System.out.println("\nEnd Result\n\n\n\n");
	return result;
    }

}
