package cve;
import java.util.*;
import ve.*;

/**
 * 

 * @author David Poole
 * @version 0.1 2001-05-22
 **/
public class ContextualBeliefNetworkRandom3 extends ContextualBeliefNetwork{

    /**
     * Constructs a random contexual belied network, where we try to minimise the number of variables in splits.

     * @param numVars the number of variables in the CBN
     * @param numSplits the numberof extra rules = the number of splits
     * @param probInFactor the probability that each remaining factor
     * is in the resulting factor.
     **/
 
    public ContextualBeliefNetworkRandom3(int numVars, int numSplits, double probInFactor) {
	variables = new Variable[numVars];
	varsSplitOn = new Variable[numVars];
	rules = new RuleCollection(numVars+numSplits);
	numVariables=numVars;
	String[] bool = {"true","false"};  // the variables will be boolean
	VarCon[] ruleSkeletons = new VarCon[numVars+numSplits];
	for (int i=0; i<numVars; i++) {
	    variables[i]=new Variable("Var"+i,bool);
	    ruleSkeletons[i] = new VarCon(variables[i],new Context());
	}
	int numRuleSkels = numVars;
	for (int j=0; j<numSplits; j++) {
	    boolean keepLooking=true;
	    do {
		int ruleSkelPos= (int) (Math.random() * (numVars+j));
		int varPos= (int) (Math.random() * numVars);
		if (variables[varPos].getId() < ruleSkeletons[ruleSkelPos].var.getId()
		    && !ruleSkeletons[ruleSkelPos].con.involves(variables[varPos])) {
		    shuffleVars();
		    for (int i=0; i<numVarsSplitOn && keepLooking; i++) {
			if (varsSplitOn[i].getId() < ruleSkeletons[ruleSkelPos].var.getId()
			    && !ruleSkeletons[ruleSkelPos].con.involves(varsSplitOn[i]))
			    {
		    ruleSkeletons[numVars+j] =
			new VarCon(ruleSkeletons[ruleSkelPos].var,
				   new Context(ruleSkeletons[ruleSkelPos].con,
					      varsSplitOn[i] ,1));
		    ruleSkeletons[ruleSkelPos] =
			new VarCon(ruleSkeletons[ruleSkelPos].var,
				   new Context(ruleSkeletons[ruleSkelPos].con,
					       varsSplitOn[i],0));
		    keepLooking=false;
			    }
		    }
			if (keepLooking) {
			    ruleSkeletons[numVars+j] =
				new VarCon(ruleSkeletons[ruleSkelPos].var,
					   new Context(ruleSkeletons[ruleSkelPos].con,
						       variables[varPos],1));
			    ruleSkeletons[ruleSkelPos] =
				new VarCon(ruleSkeletons[ruleSkelPos].var,
					   new Context(ruleSkeletons[ruleSkelPos].con,
						       variables[varPos],0));
			    varsSplitOn[numVarsSplitOn++]=variables[varPos];
			    keepLooking=false;
			}
		}
	    } while (keepLooking);
	}
	Variable[] tempVarArray = new Variable[numVars];
	for (int i=0; i<numVars+numSplits; i++) {
	    int numPars=0;
	    for (int j=0; variables[j].getId()<ruleSkeletons[i].var.getId(); j++) {
		if (Math.random() < probInFactor
		    && !ruleSkeletons[i].con.involves(variables[j]) ) {
		    tempVarArray[numPars++]=variables[j];
		}
	    }
	    Variable[] factorVars = new Variable[numPars+1];
	    for (int k=0; k<numPars; k++) {
		factorVars[k]=tempVarArray[k];
	    }
	    factorVars[numPars++]=ruleSkeletons[i].var;
	    Variable[] ruleFor = {ruleSkeletons[i].var};
	    rules.add(new GenRule(ruleSkeletons[i].con,
				  new ve.FactorUpdatable(factorVars),
				  ruleFor));
	}
    }

    private class VarCon {
	Variable var;
	Context con;
	VarCon(Variable newvar, Context newcon) {
	    var=newvar;
	    con=newcon;
	}
    }

    private Variable[] varsSplitOn;
    private int numVarsSplitOn=0;
    private void shuffleVars() {
	for (int i=numVarsSplitOn; i>1; i--) {
	    int newPos= (int) Math.random()*i;
	    if (newPos != i-1) {
		Variable tmp=varsSplitOn[newPos];
		varsSplitOn[newPos] = varsSplitOn[i-1];
		varsSplitOn[i-1] = tmp;
	    }
	}
    }
}
