package cve;
import java.util.*;
import ve.*;

/**
 * 

 * @author David Poole
 * @version 0.1 2001-05-22
 **/
public class ContextualBeliefNetworkRandom2 extends ContextualBeliefNetwork{

    /**
     * Constructs a random contexual belied network.

     * @param numVars the number of variables in the CBN
     * @param numSplits the numberof extra rules = the number of splits
     * @param probInFactor the probability that each remaining factor
     * is in the resulting factor.
     * @param probShared the probability that a variable is in both
     * sides of a slpit, given it is in either.
     **/
 
    public ContextualBeliefNetworkRandom2(int numVars, int numSplits, double probInFactor, double probShared) {
	variables = new Variable[numVars];
	rules = new RuleCollection(numVars+numSplits);
	numVariables=numVars;
	String[] bool = {"true","false"};  // the variables will be boolean
	VarTable[] ruleSkeletons = new VarTable[numVars+numSplits];
	for (int i=0; i<numVars; i++) {
	    variables[i]=new Variable("Var"+i,bool);
	    ruleSkeletons[i] = new VarTable(variables[i],i+1);
//  	    System.out.print("Factor: [");
	    for (int j=0; j<i; j++) {
		if (Math.random() < probInFactor) {
		    ruleSkeletons[i].add(variables[j]);
//  		    System.out.print(" "+variables[j].getName());
		}
	    }
//  	    System.out.println(" "+variables[i].getName()+" ]");
	}
	int numRuleSkels = numVars;
	for (int j=0; j<numSplits; j++) {
	    boolean keepLooking=true;
	    do {
		int ruleSkelPos= (int) (Math.random() * (numVars+j));
		int varPos= (int) (Math.random() * numVars);
		if (ruleSkeletons[ruleSkelPos].inPars(variables[varPos])) {
		    // we will split ruleSkeletons[ruleSkelPos] on variables[varPos]
//  		    System.out.print(" Splitting on "+variables[varPos].getName()+" skeleton: ");
//  		    ruleSkeletons[ruleSkelPos].print();
//  		    System.out.println(".");
		    Variable[] pars0 = new Variable[ruleSkeletons[ruleSkelPos].numParents+1];
		    Variable[] pars1 = new Variable[ruleSkeletons[ruleSkelPos].numParents+1];
		    int pos0=0, pos1=0;
		    for (int k=0; k<ruleSkeletons[ruleSkelPos].numParents; k++) {
			if (ruleSkeletons[ruleSkelPos].parents[k] != variables[varPos]) {
			    if (Math.random() < probShared) {
				pars0[pos0++]=ruleSkeletons[ruleSkelPos].parents[k];
				pars1[pos1++]=ruleSkeletons[ruleSkelPos].parents[k];
			    }
			    else if (Math.random() < 0.5) {
				pars0[pos0++]=ruleSkeletons[ruleSkelPos].parents[k];
			    }
			    else {
				pars1[pos1++]=ruleSkeletons[ruleSkelPos].parents[k];
			    }
			}
		    }
		    ruleSkeletons[numVars+j] =
			new VarTable(ruleSkeletons[ruleSkelPos].var,
				     pars0, pos0,
				     new Context(ruleSkeletons[ruleSkelPos].con,
					       variables[varPos],0));
//  		    System.out.print("     Creating: ");
//  		    ruleSkeletons[numVars+j].print();
//  		    System.out.println();
		    ruleSkeletons[ruleSkelPos] =
			new VarTable(ruleSkeletons[ruleSkelPos].var,
				     pars1, pos1,
				     new Context(ruleSkeletons[ruleSkelPos].con,
						 variables[varPos],1));
//  		    System.out.print("     Creating: ");
//  		    ruleSkeletons[ruleSkelPos].print();
//  		    System.out.println();
		    keepLooking=false;
		}
	    } while (keepLooking);
	}
	for (int i=0; i<numVars+numSplits; i++) {
	    Variable[] ruleFor = {ruleSkeletons[i].var};
	    ruleSkeletons[i].addVar();
	    rules.add(new GenRule(ruleSkeletons[i].con,
				  new FactorRandom(ruleSkeletons[i].parents,ruleSkeletons[i].numParents),
				  ruleFor));
	}
    }

    private class VarTable {
	Variable var;
	Variable[] parents;
	int numParents;
	Context con;
	VarTable(Variable newvar,int maxSize) {
	    var=newvar;
	    parents=new Variable[maxSize];
	    numParents=0;
	    con = new Context();
	}
	VarTable(Variable newvar, Variable[] newparents, int newNumParents, Context newcon) {
	    var=newvar;
	    parents=newparents;
	    numParents=newNumParents;
	    con=newcon;
	}
	void add(Variable par) {
	    parents[numParents++]=par;
	}
	boolean inPars(Variable var) {
	    for (int i=0; i<numParents; i++) {
		if (parents[i]==var) {
		    return true;
		}
	    }
	    return false;
	}
	void addVar() {
	    parents[numParents++]=var;
	}
	void print() {
	    System.out.print(var.getName()+" ");
	    con.print();
	    System.out.print(": [ ");
	    for (int i=0; i< numParents; i++) {
		System.out.print(parents[i].getName()+" ");
	    }
	    System.out.print("]");
	}
    }
}
