package cve;
import java.util.*;
import ve.*;

/**
 * The class of {@link ContextualBeliefNetwork}s constructed from an
 * extended CIspace representation.

 * @author David Poole
 * @version 0.1 2001-01-29
 **/
public class ContextualBeliefNetworkFromText extends ContextualBeliefNetwork{

    /**
     * constructs a belief network from the extended CIspace
     * representation.  The extended representation lets us have
     * indexes or names as the parents. It assumes that the names are
     * not numbers (otherwise it assumes they are the indexes).
     *
     * @param s string representation of the belief network
     * @param maxVariables the maximum number of variables allowed 
     **/
    ContextualBeliefNetworkFromText(String s,int maxVariables){
	variables = new Variable[maxVariables];
	numVariables=0;
	rules = new RuleCollection();
	stringToVar = new Hashtable();
	StringTokenizer variableDefns = new StringTokenizer(s,";");
        while ( variableDefns.hasMoreTokens() ) {
	    String varDef = variableDefns.nextToken();
	    varDef = varDef.trim();
	    if (varDef.indexOf("endCVE") == -1) {
		StringTokenizer varTokenizer = 
		    new StringTokenizer(varDef,"/");
		String label = varTokenizer.nextToken(); // future expansiion
		String nodeName = varTokenizer.nextToken();
		String xpos = varTokenizer.nextToken();
		String ypos = varTokenizer.nextToken();
		String domainString = varTokenizer.nextToken();
		variables[numVariables]= new Variable(nodeName,stringToStringArray(domainString,maxDomainSize));
		stringToVar.put(nodeName,variables[numVariables]);
		while (varTokenizer.hasMoreTokens() ) {
		    String ruleString=varTokenizer.nextToken();
		    StringTokenizer ruleTokenizer = 
			new StringTokenizer(ruleString,"|");
		    String contextString = ruleTokenizer.nextToken();

		    String parentsString = ruleTokenizer.nextToken();
		    String probsString = ruleTokenizer.nextToken();
		    Variable[] varArray = {variables[numVariables]};
		    rules.add( new GenRule(
					   stringToContext(contextString,maxContextSize),
					   new FactorCPT(
							 stringToParents(parentsString,numVariables,maxFactorSize),
							 probsString),
					       varArray));
		}
		numVariables++;
	    }
	}
    }

    static protected boolean sorted(Variable[] varray) {
	for (int i=1; i<varray.length; i++) {
	    if (varray[i-1].getId() >= varray[i].getId()) {
		return false;
	    }
	}
	return true;
    }

    static protected String[] stringToStringArray(String str, int maxSize) {
	String[] tempResult = new String[maxSize];
	int lpar = str.indexOf('[');
	int rpar = str.indexOf(']');
	StringTokenizer tokenizer = new StringTokenizer(str.substring(lpar+1,rpar),",");
	int size=0;
	while (tokenizer.hasMoreTokens()) {
	    tempResult[size++]=tokenizer.nextToken().trim();
	}
	String[] result = new String[size];
	for (int i=0; i<size; i++) {
	    result[i]=tempResult[i];
	}
	return result;
    }

    /**
     * given the string, return the parents
     *
     * @param str the string containing the parents' index or name
     * @param index the index of the current variable
     * @param maxSize the maximum factor size
     **/
    protected Variable[] stringToParents(String str, int index, int maxSize) {
	Variable[] tempResult = new Variable[maxSize];
	int lpar = str.indexOf('[');
	int rpar = str.indexOf(']');
	StringTokenizer tokenizer = new StringTokenizer(str.substring(lpar+1,rpar),",");
	int size=0;
	while (tokenizer.hasMoreTokens()) {
	    String nextToken = tokenizer.nextToken().trim();
	    try {
		tempResult[size]=variables[Integer.parseInt(nextToken)];
	    }
	    catch( Exception e) {   // not an integer; parent is the Name.
		// This should probably check the exception to make sure 
		// it is of the right type.
		Variable par = (Variable) stringToVar.get(nextToken);
		if (par==null) {  // should throw exception
		    System.out.println("Parent of node "+variables[index].getName()+" is undefined.");
		}
		tempResult[size]=par;
	    }
	    size++;
      	}
	Variable[] result = new Variable[size];
	for (int i=0; i<size; i++) {
	    result[i]=tempResult[i];
	}
	return result;
    }

    /**
     * given the string, return the parents
     *
     * @param str the string containing the parents' index or name
     * @param index the index of the current variable
     * @param maxSize the maximum factor size
     **/
    protected Context stringToContext(String str, int maxSize) {
	Variable[] tempVars = new Variable[maxSize];
	int[] tempVals = new int[maxSize];
	int lpar = str.indexOf('[');
	int rpar = str.indexOf(']');
	StringTokenizer tokenizer = new StringTokenizer(str.substring(lpar+1,rpar),",");
	int size=0;
	while (tokenizer.hasMoreTokens()) {
	    String nextToken = tokenizer.nextToken().trim();
	    StringTokenizer eqString = new StringTokenizer(nextToken,"=");
	    tempVars[size]=(Variable) stringToVar.get(eqString.nextToken());
	    tempVals[size]=Integer.parseInt(eqString.nextToken());
	    size++;
      	}
	Variable[] newVars = new Variable[size];
	int[] newVals = new int[size];
	
	for (int i=0; i<size; i++) {
	    newVars[i]=tempVars[i];
	    newVals[i]=tempVals[i];
	}
	return new Context(newVars,newVals);
    }

}


